<?php
date_default_timezone_set("America/Caracas");
include("conexion.php");

function actualizar_online($actual, $id) {
	global $conexion;
	$limite = $actual-2*60;
	$sql1 = mysqli_query($conexion, "UPDATE registrados SET online = '0' WHERE tiempo < '$limite'");
	$sql2 = mysqli_query($conexion, "SELECT online FROM registrados WHERE id_usuario = '$id'");
	$resultado = mysqli_fetch_assoc($sql2);
	if ($resultado['online'] != 0)
		$sql3 = mysqli_query($conexion, "UPDATE registrados SET tiempo = ".$actual." WHERE id_usuario = '$id'");
	else
		$sql3 = mysqli_query($conexion, "UPDATE registrados SET online = '1', tiempo = ".$actual." WHERE id_usuario = '$id'");
}

function consultar_status() {
	global $conexion;
	$aux = 0;
	if ($_SESSION['tipo_usuario'] > 1) {
		$sql = mysqli_query($conexion, "SELECT registrados.status AS status, registrados.status2 AS status2, suscripcion.tipo AS tipo_suscripcion, suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2 FROM registrados LEFT JOIN suscripcion ON registrados.id_usuario = suscripcion.id_usuario WHERE registrados.id_usuario = '".$_SESSION['id_usuario']."'");
		if (mysqli_num_rows($sql) > 0) {
			$status = mysqli_fetch_assoc($sql);
			if ($status['status'] == 1 || $status['status2'] == 1 || $status['suscripcion_status'] == 1 || $status['suscripcion_status2'] == 1)
				$aux = 1;
			else {
				if ($status['tipo_suscripcion'] == 2) {
					$dia_hoy = date('w');
					$sql = mysqli_query($conexion, "SELECT FIND_IN_SET($dia_hoy, dias) AS dia_semana FROM suscripcion WHERE id_usuario = '".$_SESSION['id_usuario']."'");
					if (mysqli_num_rows($sql) > 0) {
						$fila_dia = mysqli_fetch_assoc($sql);
						if ($fila_dia['dia_semana'] != 0)
							$aux = 0;
						else
							$aux = 1;
					}
				}
			}
		}
	}
	else if ($_SESSION['tipo_usuario'] == 1) {
		$sql = mysqli_query($conexion, "SELECT status FROM registrados WHERE id_usuario = '".$_SESSION['id_usuario']."'");
		if (mysqli_num_rows($sql) > 0) {
			$status = mysqli_fetch_assoc($sql);
			if ($status['status'] != 0)
				$aux = 1;
			else
				$aux = 0;
		}
	}
	return $aux;
}

function usuario_activo_inactivo($id_usuario)
{
	/**
	 * Verifica si el usuario conectado está o no
	 * usando su sesión, es decir, para verificar si está activo o inactivo.
	 */
	global $conexion;
	$tiempo_actual = time();
	$activo = 1; # activo
	$query_tiempo = mysqli_query($conexion, "SELECT tiempo FROM registrados WHERE id_usuario = '".$id_usuario."'");
	$tiempo = mysqli_fetch_assoc($query_tiempo);
	if (($tiempo_actual - $tiempo['tiempo']) > 120)
		$activo = 0; # inactivo
	return $activo;
}

function consultar_tiempo($id_usuario)
{
	global $conexion;
	$query_tiempo = mysqli_query($conexion, "SELECT tiempo FROM registrados WHERE id_usuario = '".$id_usuario."'");
	$tiempo = mysqli_fetch_assoc($query_tiempo);
	return $tiempo['tiempo'];
}

function consultar_ip($id_usuario)
{
	global $conexion;
	$query_ip = mysqli_query($conexion, "SELECT ip FROM registrados WHERE id_usuario = '".$id_usuario."'");
	$ip = mysqli_fetch_assoc($query_ip);
	return $ip['ip'];
}

function actualizar_ip($id_usuario, $nueva_ip)
{
	/**
	 * Actualiza el IP de un usuario
	 */
	global $conexion;
	mysqli_query($conexion, "UPDATE registrados SET ip = '".$nueva_ip."' WHERE id_usuario = '".$id_usuario."'");
}

function desconectar_usuario($id_usuario)
{
	global $conexion;
	mysqli_query($conexion, "UPDATE registrados SET online = 0 WHERE id_usuario = '".$id_usuario."'");
}

function consultar_canal($nro_sala, $nro_canal)
{
	global $conexion;
	$query = mysqli_query($conexion, "SELECT nro_sala, url, rtmp, activo, nro_canal FROM canales WHERE nro_sala = '".$nro_sala."' AND nro_canal = '".$nro_canal."'");
	$fila = mysqli_fetch_assoc($query);
	return $fila;
}

function consultar_sala_activa()
{
	global $conexion;
	$query = mysqli_query($conexion, "SELECT nro_sala, nro_canal, url, rtmp, activo FROM canales WHERE activo = 0 ORDER BY nro_sala ASC LIMIT 1");
	$fila = mysqli_fetch_assoc($query);
	return $fila;
}

function consultar_canal_activo($sala)
{
	global $conexion;
	$query = mysqli_query($conexion, "SELECT nro_sala, nro_canal, url, rtmp, activo FROM canales WHERE nro_sala = '".$sala."' AND activo = 0 ORDER BY nro_canal ASC LIMIT 1");
	$fila = mysqli_fetch_assoc($query);
	return $fila;
}

function consultar_id_administrador($id_usuario)
{
	global $conexion;
	$query_admin = mysqli_query($conexion, "SELECT id_administrador FROM registrados WHERE id_usuario = '".$id_usuario."'");
	$id_admin = mysqli_fetch_assoc($query_admin);
	return $id_admin['id_administrador'];
}

function consultar_pregunta_seguridad($id_usuario)
{
	global $conexion;
	$pregunta_original = array(
		1 => "¿Donde nació tu padre?",
		2 => "¿Nombre de tu mejor amigo de la infancia?",
		3 => "¿Nombre de tu abuela materna?",
		4 => "¿Cuál es el personaje histórico favorito de tu madre?",
		5 => "¿Nombre de tu abuelo paterno?");
	$query_pregunta = mysqli_query($conexion, "SELECT pregunta1 FROM preguntas WHERE id_usuario = '".$id_usuario."'");
	$pregunta_seguridad = mysqli_fetch_assoc($query_pregunta);
	return $pregunta_original[$pregunta_seguridad['pregunta1']];
}

function ver_detalles($id_usuario, $sql, $sql2, $categoria) {
	global $conexion;
	$queryConsulta = mysqli_query($conexion, $sql);
	$fila = mysqli_fetch_array($queryConsulta);
	$nombre_check = array("act" => "my-checkbox", "desc" => "my-checkbox", "susp" => "my-checkbox2");
	$accion = array("act" => "suspender_ver", "desc" => "suspender2_ver", "susp" => "renaudar_ver");
	$privilegios = array(
		"" => "0",
		"1" => "Super administrador",
		"2" => "Administrador",
		"3" => "Nacionales",
		"4" => "Americanas",
		"5" => "Americanas-Nacionales",
		"6" => "Television"
	);
	$status  = array(0 => "Activo", 1 => "Suspendido", 2 => "Activo");
	$title = array("act" => "Suspender", "desc" => "Suspender", "susp" => "Activar");
	$icon = array("act" => '<i class="glyphicon glyphicon-minus"></i>', "desc" => '<i class="glyphicon glyphicon-minus"></i>', "susp" => '<i class="glyphicon glyphicon-ok"></i>');
	if ($fila['status'] == '1') {
		$checked_todos = "checked";
		$name_todos = "my-checkbox-todos1";
	}else {
		$checked_todos = "";
		$name_todos = "my-checkbox-todos2";
	}
	if (mysqli_num_rows($queryConsulta) > 0) {
		$salida_detalles = '
			<div class="barra-botones">
				<div class="container-fluid">
					<div class="contenedor-botones">
						<button class="btn btn-info" data-toggle="" title="Volver" data-placement="bottom" onClick="history.go(-1)"><i class="glyphicon glyphicon-arrow-left"></i></button>';
						if ($_SESSION["tipo_usuario"] == 1) {
							$salida_detalles .= ' <button class="btn btn-info" href="'.$id_usuario.'" data-accion="eliminar_ver" data-toggle="eliminar_usuario" title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i></button>';
						}else if ($_SESSION["tipo_usuario"] == 2) {
							if ($fila["privilegios"] > 2) {
								$salida_detalles .= ' <button class="btn btn-info" href="'.$id_usuario.'" data-accion="eliminar_ver" data-toggle="eliminar_usuario" title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i></button>';
							}
						}
						$salida_detalles .= '<div class="btn-group2">';
							if ( $categoria != 'todos' && $categoria != 'mis_usuarios' )
								$salida_detalles .= '<button type="button" class="btn btn-info" data-accion="'.$accion[$categoria].'" data-busqueda="'.$id_usuario.'" data-toggle="confirmar" title='.$title[$categoria].' data-placement="bottom">'.$icon[$categoria].'</button>';
							else
							{
								$salida_detalles .= '
									<button type="button" class="btn btn-info" data-accion="susp_todos_ver" data-busqueda="'.$id_usuario.'" data-toggle="confirmar" title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i></button>
									<button type="button" class="btn btn-info" data-accion="renaudar_todos_ver" data-busqueda="'.$id_usuario.'" data-toggle="confirmar" title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i></button>
								';
							}
						$salida_detalles .= '</div>
					</div>
					<div class="buscar">
						<input type="text" id="campo_busqueda" placeholder="Buscar usuario">
						<a href="#" class="abrir-buscar"><i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i></a>
					</div>
				</div>
			</div>
			<div class="container">
				<div class="col-xs-12 col-sm-5 col-md-5 col-lg-5">
					<div class="panel panel-info" style="">
						<div class="panel-heading">
							<h3 class="panel-title" style="display:inline"><i class="glyphicon glyphicon-user"></i> '.$fila['nombre'].'</h3>
							'.estado($fila["online"], $fila["status"], $fila["status2"], $fila["suscripcion_status"], $fila["suscripcion_status2"]).'
						</div>
						<div class="panel-body" style="padding:0">
							<div class="table-responsive">
								<table class="table table-condensed ">
									<tbody>
										<tr><th width="125" align="left">Dirección IP:</th><td align="right">'.$fila['ip'].'</td></tr>
										<tr><th width="100" align="left">Privilegios:</th><td align="right">'.$privilegios[$fila['privilegios']].'</td></tr>';
										if ($fila["privilegios"] > 2 && $fila["id_administrador"] != 0 && $_SESSION["tipo_usuario"] == 1) {
											$query_admin = mysqli_query($conexion, "SELECT id_usuario, nombre FROM registrados WHERE id_usuario = '".$fila["id_administrador"]."'");
											$administrador_nombre = mysqli_fetch_array($query_admin);
											$salida_detalles .= '<tr><th width="150">Administrado por:</th><td align="right"><a href="../cl/todos.php?id_usuario='.$administrador_nombre["id_usuario"].'">'.$administrador_nombre["nombre"].'</a></td></tr>';
										}
											$salida_detalles .= '<tr><th>Status:</th><td align="right">'.$status[$fila["status"]].'</td></tr>';
											if ($_SESSION["tipo_usuario"] == 2 && $fila["privilegios"] == 2)
												$salida_detalles .= '<td style="border-bottom:none"></td>';
											else {
												if ($categoria == "todos" || $categoria == "mis_usuarios")
													$salida_detalles .= '<tr><td style="border-bottom:none"><input type="checkbox" checked name="'.$name_todos.'" class="bootstrap-switch-mini" '.$checked_todos.' value="'.$id_usuario.'" ></td>';
												else
												   $salida_detalles .= '<tr><td style="border-bottom:none"><input type="checkbox" checked name="'.$nombre_check[$categoria].'" class="bootstrap-switch-mini" value="'.$id_usuario.'" ></td>';
											}
											$salida_detalles .= '<td align="right" height="35" style="border-bottom:none">
												<a href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
													<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
												</a>
												<a href="'.$fila['id_usuario'].'" data-accion="modificar_ver" data-toggle="actualizar_usuario"
													dbd_clave="'.$fila['clave'].'" dbd_nombre="'.$fila['nombre'].'" dbd_priv="'.$fila['privilegios'].'"
													dbd_max="'.$fila['max'].'" dbd_susc_tipo="'.$fila['suscripcion_tipo'].'"
													dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'" dbd_susc_dias="'.$fila['suscripcion_dias'].'" >
													<i class="glyphicon glyphicon-edit" title="Modificar"></i>
												</a>
											</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
					</div>';
					if ($fila['privilegios'] != 1) {
						$tipo_suscripcion = array(1 => "Prueba", 2 => "Semanal", 3 => "Mensual");
						$nombre_tiempo = array(1 => "N° minutos", 2 => "Días", 3 => "N° meses");
						$salida_detalles .= '
							<div class="panel panel-info">
								<div class="panel-heading">
									<h3 class="panel-title" style="display:inline"> Suscripción</h3>
								</div>
								<div class="panel-body" style="padding:0">
									<div class="table-responsive">
										<table class="table table-condensed" style="margin-bottom:0">
											<tbody>
												<tr><th width="125" align="left">Fecha:</th><td align="right">'.date("d/m/Y h:i:s a", strtotime($fila['suscripcion_fecha'])).'</td></tr>
												<tr><th width="125" align="left">Tipo:</th><td align="right">'.$tipo_suscripcion[$fila['suscripcion_tipo']].'</td></tr>';
												if ($fila['suscripcion_tipo'] == 1 || $fila['suscripcion_tipo'] == 3) {
													($fila['suscripcion_tipo'] == 1) ? $nro_horas = ' ('.floor($fila['suscripcion_tiempo']/60).' hrs)' : $nro_horas = '';
													$salida_detalles .= '
														<tr><th width="100" align="left">'.$nombre_tiempo[$fila['suscripcion_tipo']].':</th><td align="right">'.$fila['suscripcion_tiempo'].$nro_horas.'</td></tr>
														<tr><th width="150" align="left">Fecha caducidad:</th><td align="right">'.date("d/m/Y h:i:s a", caducidad_suscripcion($fila['suscripcion_tipo'],$fila['suscripcion_tiempo'],$fila['suscripcion_fecha'])).'</td></tr>
													';
												}
												if ($fila['suscripcion_tipo'] == 2) {
													$dias = str_replace(",",", ", $fila['suscripcion_dias']);
													$n_dias = array("1", "2", "3", "4", "5", "6", "0");
													$nomb_dias = array("Lun", "Mar", "Mie", "Jue", "Vie", "Sáb", "Dom");
													$salida_detalles .= '
														<tr><th width="100" align="left">'.$nombre_tiempo[$fila['suscripcion_tipo']].':</th><td align="right">'.str_replace($n_dias, $nomb_dias, $dias).'</td></tr>
													';
												}
												$salida_detalles .= '
											</tbody>
										</table>
									</div>
								</div>
								<div class="panel-footer" style="padding:19px;border-top:0"></div>
							</div>
						';
					}
				$salida_detalles .= '</div>';
				$queryEntradas = mysqli_query($conexion, $sql2);
				$actividad = array(
					1 => "Inició sesión por primera vez con el número de IP: ",
					2 => "Inició sesión con nuevo número de IP: ",
					3 => "Inició sesión",
					4 => "Intentó iniciar sesión con un número de IP diferente: ",
					5 => "Intentó iniciar sesión con la cuenta suspendida",
					#6 => "Inició sesión por primera vez con una conexión eventual",
					#7 => "IP restablecida",
					7  => "Pregunta de seguridad restablecida",
					8 => "Intento fallido de conexión simultánea",
					9 => "La suscripción ha caducado",
					10 => "Intentó iniciar sesión con la suscripción caducada",
					11 => "Suscripción renovada",
					12 => "Intentó iniciar sesión con suscripción semanal inválida",
					13 => "Intentó iniciar sesión con suscripción de administrador caducada",
					14 => "Intentó iniciar sesión con la cuenta de administrador suspendida");
				$actividad_list = array(1 => "list-group-item", 2 => "list-group-item", 3 => 'list-group-item', 4 => "list-group-item list-group-item-warning", 5 => "list-group-item list-group-item-warning", 6 => "list-group-item", 7 => "list-group-item", 8 => "list-group-item list-group-item-warning", 9 => "list-group-item list-group-item-success", 10 => "list-group-item list-group-item-warning", 11 => "list-group-item", 12 => "list-group-item list-group-item-warning", 13 => "list-group-item list-group-item-warning", 14 => "list-group-item list-group-item-warning");
				$salida_detalles .= '
				 <div class="col-xs-12 col-sm-7 col-md-7 col-lg-7" >
					<div class="panel panel-info">
						<div class="panel-heading">
							<h3 class="panel-title">Historial de notificaciones</h3>
						</div>';
						if (mysqli_num_rows($queryEntradas) > 0) {
							$salida_detalles .= '<ul class="list-group">';
								while ($fila_entradas = mysqli_fetch_array($queryEntradas)) {
									$salida_detalles .= '
 										<li class="'.$actividad_list[$fila_entradas['actividad']].'">
    										<span style="font-weight:bold" >'.date("d/m/Y",$fila_entradas['fecha']).'</span>
   											<span class="badge">'.date("h:i:s a",$fila_entradas['fecha']).'</span>';
											if ($fila_entradas['actividad'] == 3) {
												$salida_detalles .= '<p class="list-group-item-text">'.$actividad[$fila_entradas['actividad']].'</p>';
											}else {
												$salida_detalles .= '<p class="list-group-item-text">'.$actividad[$fila_entradas['actividad']].''.$fila_entradas['direccion_ip'].'</p>';
											}
  										$salida_detalles .= '</li>';
								}// Fin while
								$salida_detalles .= '
									</ul>
									<div id="cargar_entradas_footer" class="panel-footer" style="border-top:none;text-align:center">
										<span style="font-weight:bold;color:#5bc0de">...</span>
									</div>
								';
						}else {
							$salida_detalles .= '
								<div class="panel-body">
									No hay registros.
								</div>
							';
						}
					$salida_detalles .= '</div>';// .panel
			$salida_detalles .= '</div>';// .col
		$salida_detalles .= '</div>';// .container*/
	}else {
		$salida_detalles = '
			<div class="barra-botones">
				<div class="container-fluid">
					<div class="col-xs-12 col-sm-8 col-md-8 col-lg-8" style="padding:5px 0;height:40px">
						<button class="btn btn-info" data-toggle="" title="Volver" data-placement="bottom" onClick="history.go(-1)"><li class="glyphicon glyphicon-arrow-left"></li></button>
					</div>
					<div class="col-xs-12 col-sm-4 col-md-4 col-lg-4 buscar">
						<input type="text" id="campo_busqueda" placeholder="Buscar usuario">
						<a href="#" class="abrir-buscar"><i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i></a>
					</div>
				</div>
			</div>
			<div class="col-lg-12 subtitulo2">Usuario no encontrado.</div>
		';
	}
	return $salida_detalles;
}

function buscar($filtro, $sql, $categoria) {
	global $conexion;
	$consulta = mysqli_query($conexion, $sql);
	$total_filas = mysqli_num_rows($consulta);
	$color_badge = array("act" => "#f0ad4e", "desc" => "", "susp" => "#434343", "todos" => "#5bc0de", "mis_usuarios" => "#5bc0de");
	$nombre_check = array("act" => "my-checkbox", "desc" => "my-checkbox", "susp" => "my-checkbox2");
	$accion = array("act" => "suspender_buscar", "desc" => "suspender2_buscar", "susp" => "renaudar_buscar");
	$privilegios = array(
		"" => "0",
		"1" => "Super administrador",
		"2" => "Administrador",
		"3" => "Nacionales",
		"4" => "Americanas",
		"5" => "Americanas-Nacionales",
		"6" => "Television"
	);
	$status  = array(0 => "Activo", 1 => "Suspendido", 2 => "Activo");
	$title = array("act" => "Suspender", "desc" => "Suspender", "susp" => "Activar");
	$icon = array("act" => '<i class="glyphicon glyphicon-minus"></i>', "desc" => '<i class="glyphicon glyphicon-minus"></i>', "susp" => '<i class="glyphicon glyphicon-ok"></i>');
	$salida_busqueda = '
		<div class="barra-botones">
			<div class="container-fluid">
				<div class="contenedor-botones">
					<button class="btn btn-info" title="Volver" data-placement="bottom" onClick="history.go(-1)"><i class="glyphicon glyphicon-arrow-left"></i></button>
					<button class="btn btn-info" title="Actualizar" data-toggle="actualizar" data-accion="actualizar_buscar" data-busqueda="'.$filtro.'" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i></button>
					<button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="guardar_buscar" data-busqueda="'.$filtro.'" data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i></button>
					<div class="btn-group2">
						<button type="button" class="btn btn-info" data-accion="eliminar_array_buscar" data-toggle="confirmar" data-busqueda="'.$filtro.'" title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i></button>';
						if ( $categoria != 'todos' && $categoria != 'mis_usuarios' )
							$salida_busqueda .= ' <button type="button" class="btn btn-info" data-accion="'.$accion[$categoria].'" data-busqueda="'.$filtro.'" data-toggle="confirmar" title='.$title[$categoria].' data-placement="bottom">'.$icon[$categoria].'</button>';
						else
						{
							$salida_busqueda .= '
								<button type="button" class="btn btn-info" data-accion="susp_todos_buscar" data-busqueda="'.$filtro.'" data-toggle="confirmar" title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i></button>
								<button type="button" class="btn btn-info" data-accion="renaudar_todos_buscar" data-busqueda="'.$filtro.'" data-toggle="confirmar" title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i></button>
							';
						}
						$salida_busqueda .= ' <button type="button" class="btn btn-info" data-accion="reestablecer_array_buscar" data-busqueda="'.$filtro.'" data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom"><i class="glyphicon glyphicon-repeat"></i></button>
					</div>
				</div>
				<div class="buscar">
					<input type="text" id="campo_busqueda" placeholder="Buscar usuario" value="'.$filtro.'">
					<a href="#" class="abrir-buscar"><i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i></a>
				</div>
			</div>
		</div>
	';
	if ($total_filas > 0)
	{
		$salida_busqueda .= '
			<div class="subtitulo">
				<p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos" data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i></a> Resultados de la búsqueda <span class="badge" style="background-color:'.$color_badge[$categoria].'">'.$total_filas.'</span></p>
			</div>
		';

		$salida_busqueda .= '
			<div class="table-responsive">
				<table class="table table-usuarios">
					<thead>
						<tr>
							<th>Usuario</th>';
							if ($categoria == 'mis_usuarios')
								$salida_busqueda .= '<th>Contraseña</th>';
							$salida_busqueda .= '<th>Dirección IP</th>
							<th>Privilegios</th>
							<th>Status</th>
							<th>Acciones</th>
						</tr>
					</thead>
					<tbody>
			';

		while( $fila = mysqli_fetch_assoc($consulta) )
		{
			if ($fila['status'] == '1') {
				$checked_todos = "checked";
				$name_todos = "my-checkbox-todos1";
			}
			else {
				$checked_todos = "";
				$name_todos = "my-checkbox-todos2";
			}
			($_SESSION["tipo_usuario"] == 2 && $fila["privilegios"] == 2)? $disabled="disabled='disabled'" : $disabled="";

			$salida_busqueda .= '
				<tr>
					<td>
						'.$fila["nombre"].
						estado(
							$fila["online"], $fila["status"], $fila["status2"],
							$fila["suscripcion_status"], $fila["suscripcion_status2"]
						).'
					</td>';
					if ($categoria == 'mis_usuarios')
						$salida_busqueda .= '<td>'.$fila["clave"].'</td>';
					$salida_busqueda .= '<td>'.$fila["ip"].'</td>
					<td>'.$privilegios[ $fila['privilegios'] ].'</td>
					<td>'.$status[ $fila["status"] ].'</td>';

					$salida_busqueda .='
					<td>
						<div class="acciones">';

					if ( $_SESSION["tipo_usuario"] == 1 )
					{
						$salida_busqueda .= '
						<a class="e1" href="?id_usuario='.$fila['id_usuario'].'" data-accion="ver_detalles" data-toggle="ver_detalles">
							<i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
						</a>
						<a class="e1" href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
							<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
						</a>
						<a class="e1" href="'.$fila['id_usuario'].'" data-accion="eliminar_buscar" data-toggle="eliminar_usuario" data-busqueda="'.$filtro.'">
							<i class="glyphicon glyphicon-trash" title="Eliminar"></i>
						</a>';
					}

					else if ( $_SESSION["tipo_usuario"] == 2 )
					{
						if ( ($fila["id_usuario"] == $_SESSION["id_usuario"])
							|| ($_SESSION["id_usuario"] == $fila["id_administrador"]) )
						{
							$salida_busqueda .= '
							<a class="e1" href="?id_usuario='.$fila['id_usuario'].'" data-accion="ver_detalles" data-toggle="ver_detalles">
								<i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
							</a>
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
								<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
							</a>';
							if ( $fila["privilegios"] > 2 )
							{
								$salida_busqueda .= '
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="eliminar_buscar" data-toggle="eliminar_usuario" data-busqueda="'.$filtro.'">
									<i class="glyphicon glyphicon-trash" title="Eliminar"></i>
								</a>';
							}
						}
					}
					$salida_busqueda .= '
					<a class="e1" href="'.$fila['id_usuario'].'" data-accion="modificar_buscar" data-toggle="actualizar_usuario" data-busqueda="'.$filtro.'"
						dbd_clave="'.$fila['clave'].'" dbd_nombre="'.$fila['nombre'].'" dbd_priv="'.$fila['privilegios'].'" dbd_max="'.$fila['max'].'"
						dbd_susc_tipo="'.$fila['suscripcion_tipo'].'" dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'" dbd_susc_dias="'.$fila['suscripcion_dias'].'" >
						<i class="glyphicon glyphicon-edit" title="Modificar"></i>
					</a>
				</div>';
				if ($_SESSION["tipo_usuario"] == 1)
				{
					if ( ($fila["id_usuario"] == $_SESSION["id_usuario"]) || ($fila["privilegios"] != 1) )
					{
						if ($categoria == "todos" || $categoria == "mis_usuarios")
							$salida_busqueda .= ' <input type="checkbox" checked name="'.$name_todos.'" class="bootstrap-switch-mini" '.$checked_todos.' value="'.$fila['id_usuario'].'" >';
						else
						   $salida_busqueda .= ' <input type="checkbox" checked name="'.$nombre_check[$categoria].'" class="bootstrap-switch-mini" value="'.$fila['id_usuario'].'" >';
						}
				}
				else if ( !($_SESSION["tipo_usuario"] == 2 && $fila["privilegios"] == 2) )
				{
					if ($categoria == "todos")
						$salida_busqueda .= ' <input type="checkbox" checked name="'.$name_todos.'" class="bootstrap-switch-mini" '.$checked_todos.' value="'.$fila['id_usuario'].'" >';
					else
					   $salida_busqueda .= ' <input type="checkbox" checked name="'.$nombre_check[$categoria].'" class="bootstrap-switch-mini" value="'.$fila['id_usuario'].'" >';
				}
				$salida_busqueda .= '</td>
			</tr>';
		} #fin while

		$salida_busqueda .= '
					</tbody>
				</table>
			</div>';

	}else {
		$salida_busqueda .= '
			<div class="subtitulo">
				<p>Resultados de la búsqueda <span class="badge" style="background-color:'.$color_badge[$categoria].'">'.$total_filas.'</span></p>
			</div>
			<div class="col-lg-12 subtitulo2">No hay resultados de usuarios para <span style="font-weight:bold">'.$filtro.'</span>.</div>
		';
	}
	return $salida_busqueda;
}

function cargar_online($pag_num){
	global $conexion;
	if (isset($_GET['id_usuario']))
	{
		if ($_SESSION["tipo_usuario"] == 1)
		{
			if ($_SESSION["id_usuario"] == $_GET['id_usuario'])
			{
				$consulta_ver = "SELECT registrados.* FROM registrados
					WHERE (registrados.id_usuario = '".$_SESSION['id_usuario']."'
						AND registrados.status = '0' AND registrados.online = '1')";

				$consulta_ver2 = "SELECT direccion_ip, fecha, actividad
					FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario
					WHERE (entradas.usuario_id = '".$_GET['id_usuario']."'
						AND registrados.status = '0' AND registrados.online = '1')
					ORDER BY entradas.fecha DESC LIMIT 0,10";
			}
			else
			{
				$consulta_ver = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo,
					suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.fecha AS suscripcion_fecha,
					suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
					FROM registrados
					LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
					LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
					WHERE (registrados.privilegios != 1 AND registrados.id_usuario = '".$_GET['id_usuario']."'
						AND registrados.status = '0' AND registrados.online = '1')";

				$consulta_ver2 = "SELECT direccion_ip, fecha, actividad
					FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario
					WHERE (registrados.privilegios != 1 AND entradas.usuario_id = '".$_GET['id_usuario']."'
						AND registrados.status = '0' AND registrados.online = '1')
					ORDER BY entradas.fecha DESC LIMIT 0,10";
			}
		}
		else if ($_SESSION["tipo_usuario"] == 2)
		{
			$consulta_ver = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.fecha AS suscripcion_fecha, suscripcion.dias AS suscripcion_dias FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status = '0' AND registrados.online = '1' AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') AND registrados.id_usuario = '".$_GET['id_usuario']."'";
			$consulta_ver2 = "SELECT direccion_ip, fecha, actividad FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario WHERE entradas.usuario_id = '".$_GET['id_usuario']."' AND registrados.status = '0' AND registrados.online='1' AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') ORDER BY entradas.fecha DESC LIMIT 0,10";
		}
		$salida = ver_detalles($_GET['id_usuario'], $consulta_ver, $consulta_ver2, "act");
	}
	else if (isset($_GET['buscar']))
	{
		if ($_SESSION["tipo_usuario"] == 1)
			$consulta_buscar = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status = '0' AND registrados.online = '1' AND registrados.nombre LIKE '%".$_GET['buscar']."%' ORDER BY registrados.privilegios ASC";
		else if ($_SESSION["tipo_usuario"] == 2)
			$consulta_buscar = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status = '0' AND registrados.online = '1' AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') AND (registrados.nombre LIKE '%".$_GET['buscar']."%') ORDER BY registrados.privilegios ASC";
		$salida = buscar($_GET['buscar'], $consulta_buscar, "act");
	}
	else
	{
		$salida = '
			<div class="barra-botones">
				<div class="container-fluid">
					<div class="contenedor-botones">
						<button class="btn btn-info" title="Actualizar" data-toggle="actualizar" data-accion="actualizar_online" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i></button>
						<button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="guardar" data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i></button>
						<div class="btn-group2">
							<button type="button" class="btn btn-info" data-accion="eliminar_array" data-toggle="confirmar" title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i></button>
							<button type="button" class="btn btn-info" data-accion="suspender" data-toggle="confirmar" title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i></button>
							<button type="button" class="btn btn-info" data-accion="reestablecer_array" data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom"><i class="glyphicon glyphicon-repeat"></i></button>
						</div>
					</div>
					<div class="buscar">
						<input type="text" id="campo_busqueda" placeholder="Buscar usuario">
						<a href="#" class="abrir-buscar"><i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i></a>
					</div>
				</div>
			</div>
		';
		if ($_SESSION["tipo_usuario"] == 1)
		{
			$restriccion2 = "";
			$restriccion1 = "";
		}
		else if ($_SESSION["tipo_usuario"] == 2)
		{
			$restriccion2 = " AND (id_usuario = '".$_SESSION['id_usuario']."' || id_administrador = '".$_SESSION['id_usuario']."')";
			$restriccion1 = " AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."')";
		}
		$queryConsulta2 = mysqli_query($conexion, "SELECT * FROM registrados WHERE status = '0' AND online = '1' $restriccion2");
		$totalFilas = mysqli_num_rows($queryConsulta2);
		if($totalFilas > 0) {
			$filas_pagina = 24;
			$total_paginas = ceil($totalFilas/$filas_pagina);
			if (isset($_GET['pag'])) {
				$pag_num = $_GET['pag'];
			}else {
				if ($pag_num != 1) {
					$pag_num = ($pag_num > $total_paginas) ? $pag_num - 1 : $pag_num;
				}else {
					$pag_num = $pag_num;
				}
			}
			$offset = ($pag_num - 1) * $filas_pagina;
			$queryConsulta = mysqli_query($conexion, "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status = '0' AND registrados.online = '1' $restriccion1 ORDER BY registrados.privilegios ASC LIMIT $offset, $filas_pagina");
			$privilegios = array(
				"" => "0",
				"1" => "Super administrador",
				"2" => "Administrador",
				"3" => "Nacionales",
				"4" => "Americanas",
				"5" => "Americanas-Nacionales",
				"6" => "Television"
			);
			$salida .= '
				<div class="subtitulo" style="clear:left">
					<p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos" data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i></a> Usuarios en línea <span class="badge" style="background-color:#f0ad4e">'.$totalFilas.'</span></p>
				</div>
			';

			$salida .= '
			<div class="table-responsive">
				<table class="table table-usuarios">
					<thead>
						<tr>
							<th>Usuario</th>
							<th>Dirección IP</th>
							<th>Privilegios</th>
							<th>Status</th>
							<th>Acciones</th>
						</tr>
					</thead>
					<tbody>
			';

			while( $fila = mysqli_fetch_assoc($queryConsulta) )
			{
				($_SESSION["tipo_usuario"] == 2 && $fila["privilegios"] == 2)? $disabled="disabled='disabled'" : $disabled="";

				$salida .= '
				<tr>
					<td>
						'.$fila["nombre"].'
						<h3 class="estado glyphicon glyphicon-asterisk" title="En línea" data-placement="bottom" style="color:#f0ad4e;font-size:12px"></h3>
					</td>
					<td>'.$fila["ip"].'</td>
					<td>'.$privilegios[ $fila['privilegios'] ].'</td>
					<td>Activo</td>';

					$salida .='
					<td>
						<div class="acciones">';

					if ( $_SESSION["tipo_usuario"] == 1 )
					{
						if ( ($fila["id_usuario"] == $_SESSION["id_usuario"]) || $fila["privilegios"] != 1 )
						{
							$salida .= '
								<a class="e1" href="?id_usuario='.$fila['id_usuario'].'" data-accion="ver_detalles" data-toggle="ver_detalles">
									<i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
								</a>
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
									<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
								</a>
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="eliminar" data-toggle="eliminar_usuario">
									<i class="glyphicon glyphicon-trash" title="Eliminar"></i>
								</a>
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="modificar" data-toggle="actualizar_usuario"
									dbd_clave="'.$fila['clave'].'" dbd_nombre="'.$fila['nombre'].'" dbd_priv="'.$fila['privilegios'].'"
									dbd_max="'.$fila['max'].'" dbd_susc_tipo="'.$fila['suscripcion_tipo'].'"
									dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'" dbd_susc_dias="'.$fila['suscripcion_dias'].'" >
									<i class="glyphicon glyphicon-edit" title="Modificar"></i>
								</a>';
						}
					}
					else if ( $_SESSION["tipo_usuario"] == 2 )
					{
						if ( ($fila["id_usuario"] == $_SESSION["id_usuario"])
							|| ($_SESSION["id_usuario"] == $fila["id_administrador"]) )
						{
							$salida .= '
							<a class="e1" href="?id_usuario='.$fila['id_usuario'].'" data-accion="ver_detalles" data-toggle="ver_detalles">
								<i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
							</a>
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
								<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
							</a>';
							if ( $fila["privilegios"] > 2 )
							{
								$salida .= '
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="eliminar" data-toggle="eliminar_usuario">
									<i class="glyphicon glyphicon-trash" title="Eliminar"></i>
								</a>';
							}
							$salida .= '
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="modificar" data-toggle="actualizar_usuario"
									dbd_clave="'.$fila['clave'].'" dbd_nombre="'.$fila['nombre'].'" dbd_priv="'.$fila['privilegios'].'"
									dbd_max="'.$fila['max'].'" dbd_susc_tipo="'.$fila['suscripcion_tipo'].'"
									dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'" dbd_susc_dias="'.$fila['suscripcion_dias'].'" >
									<i class="glyphicon glyphicon-edit" title="Modificar"></i>
								</a>';
						}
					}
					$salida .= '
						</div>';
						if ($_SESSION["tipo_usuario"] == 1)
						{
							if ( ($fila["id_usuario"] == $_SESSION["id_usuario"]) || ($fila["privilegios"] != 1) )
								$salida .= '
									<input type="checkbox" name="my-checkbox" class="bootstrap-switch-mini" value="'.$fila['id_usuario'].'" checked>';
						}
						else if ( !($_SESSION["tipo_usuario"] == 2 && $fila["privilegios"] == 2) )
						{
							$salida .= '
								<input type="checkbox" name="my-checkbox" class="bootstrap-switch-mini" value="'.$fila['id_usuario'].'" checked>';
						}
						$salida .= '</td>
					</tr>';
			} #fin while

			$salida .= '
					</tbody>
				</table>
			</div>';

			if ($total_paginas > 1) {
				$salida .= '<div style="clear:left;text-align:center"><ul class="pagination">';
				if ($pag_num != 1) {
					$salida .= '<li><a href="../cl/act.php?pag=1" class="paginate" style="cursor:pointer" title="Primero">&laquo;</a></li><li><a href="../cl/act.php?pag='.($pag_num-1).'" class="paginate" style="cursor:pointer" title="Anterior">&#8249;</a></li>';
				}
				$salida .= '<li><a class="paginate2">Página '.$pag_num.' de '.$total_paginas.'</a></li>';
				if ($pag_num != $total_paginas) {
					$salida .= '<li><a href="../cl/act.php?pag='.($pag_num+1).'" class="paginate" style="cursor:pointer" title="Siguiente">&#8250;</a></li><li><a href="../cl/act.php?pag='.$total_paginas.'" class="paginate" style="cursor:pointer" title="Último">&raquo;</a></li>';
				}
				$salida .= '</ul></div>';
			}
		}
		else
		{
			$salida .= '
				<div class="subtitulo">
					<p>Usuarios en línea <span class="badge" style="background-color:#f0ad4e">0</span></p>
				</div>
				<div class="col-lg-12 subtitulo2">No hay usuarios en línea.</div>
			';
		}
	}
	return $salida;
}

function cargar_offline($pag_num){
	global $conexion;
	if (isset($_GET['id_usuario']))
	{
		if ($_SESSION["tipo_usuario"] == 1)
		{
			$consulta_ver = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo,
				suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
				suscripcion.fecha AS suscripcion_fecha, suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status,
				suscripcion.status2 AS suscripcion_status2
				FROM registrados
				LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
				LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
				WHERE (registrados.privilegios != 1 AND registrados.status != 1 AND registrados.online = '0'
					AND registrados.id_usuario = '".$_GET['id_usuario']."')";

			$consulta_ver2 = "SELECT direccion_ip, fecha, actividad
				FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario
				WHERE (registrados.privilegios != 1 AND entradas.usuario_id = '".$_GET['id_usuario']."'
					AND registrados.status != 1 AND registrados.online='0')
				ORDER BY entradas.fecha DESC LIMIT 0,10";
		}
		else if ($_SESSION["tipo_usuario"] == 2)
		{
			$consulta_ver = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.fecha AS suscripcion_fecha, suscripcion.dias AS suscripcion_dias FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status != 1 AND registrados.online = '0' AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') AND registrados.id_usuario = '".$_GET['id_usuario']."'";
			$consulta_ver2 = "SELECT direccion_ip, fecha, actividad FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario WHERE entradas.usuario_id = '".$_GET['id_usuario']."' AND registrados.status != 1 AND registrados.online='0' AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') ORDER BY entradas.fecha DESC LIMIT 0,10";
		}
		$salida = ver_detalles($_GET['id_usuario'], $consulta_ver, $consulta_ver2, "desc");
	}else if (isset($_GET['buscar'])) {
		if ($_SESSION["tipo_usuario"] == 1) {
			$consulta_buscar = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2 FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status != 1 AND registrados.online = '0' AND registrados.nombre LIKE '%".$_GET['buscar']."%' ORDER BY registrados.privilegios ASC";
		}
		else if ($_SESSION["tipo_usuario"] == 2) {
			$consulta_buscar = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status != 1 AND registrados.online = '0' AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') AND (registrados.nombre LIKE '%".$_GET['buscar']."%') ORDER BY registrados.privilegios ASC";
		}
		$salida = buscar($_GET['buscar'], $consulta_buscar, "desc");
	}else {
		$salida = '
			<div class="barra-botones">
				<div class="container-fluid">
					<div class="contenedor-botones">
						<button class="btn btn-info" title="Actualizar" data-toggle="actualizar" data-accion="actualizar_offline" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i></button>
						<button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="guardar" data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i></button>
						<div class="btn-group2">
							<button type="button" class="btn btn-info" data-accion="eliminar_array" data-toggle="confirmar" title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i></button>
							<button type="button" class="btn btn-info" data-accion="suspender2" data-toggle="confirmar" title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i></button>
							<button type="button" class="btn btn-info" data-accion="reestablecer_array" data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom"><i class="glyphicon glyphicon-repeat"></i></button>
						</div>
					</div>
					<div class="buscar">
						<input type="text" id="campo_busqueda" placeholder="Buscar usuario">
						<a href="#" class="abrir-buscar"><i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i></a>
					</div>
				</div>
			</div>
		';
		if ($_SESSION["tipo_usuario"] == 1) {
			$restriccion2 = "";
			$restriccion1 = "";
		}else if ($_SESSION["tipo_usuario"] == 2) {
			$restriccion2 = " AND (id_usuario = '".$_SESSION['id_usuario']."' || id_administrador = '".$_SESSION['id_usuario']."')";
			$restriccion1 = " AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."')";
		}
		$queryConsulta2 = mysqli_query($conexion, "SELECT * FROM registrados WHERE status != 1 AND online = '0' $restriccion2");
		$totalFilas = mysqli_num_rows($queryConsulta2);
		if($totalFilas > 0) {
			$filas_pagina = 24;
			$total_paginas = ceil($totalFilas/$filas_pagina);
			if (isset($_GET['pag'])) {
				$pag_num = $_GET['pag'];
			}else {
				if ($pag_num != 1)
					$pag_num = ($pag_num > $total_paginas) ? $pag_num - 1 : $pag_num;
				else
					$pag_num = $pag_num;
			}
			$offset = ($pag_num - 1) * $filas_pagina;
			$queryConsulta = mysqli_query($conexion, "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2 FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status != 1 AND registrados.online = '0' $restriccion1 ORDER BY registrados.privilegios ASC LIMIT $offset, $filas_pagina");
			$privilegios = array(
				"" => "0",
				"1" => "Super administrador",
				"2" => "Administrador",
				"3" => "Nacionales",
				"4" => "Americanas",
				"5" => "Americanas-Nacionales",
				"6" => "Television"
			);
			$salida .= '
				<div class="subtitulo">
					<p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos" data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i></a> Usuarios desconectados <span class="badge">'.$totalFilas.'</span></p>
				</div>
			';

			$salida .= '
			<div class="table-responsive">
				<table class="table table-usuarios">
					<thead>
						<tr>
							<th>Usuario</th>
							<th>Dirección IP</th>
							<th>Privilegios</th>
							<th>Status</th>
							<th>Acciones</th>
						</tr>
					</thead>
					<tbody>
			';

			while( $fila = mysqli_fetch_assoc($queryConsulta) )
			{
				$salida .= '
				<tr>
					<td>
						'.$fila["nombre"].
						estado(
							$fila["online"], $fila["status"], $fila["status2"],
							$fila["suscripcion_status"], $fila["suscripcion_status2"]
						).'
					</td>
					<td>'.$fila["ip"].'</td>
					<td>'.$privilegios[ $fila['privilegios'] ].'</td>
					<td>Activo</td>';

					$salida .='
					<td>
						<div class="acciones">';

					if ( $_SESSION["tipo_usuario"] == 1 )
					{
						if ( ($fila["id_usuario"] == $_SESSION["id_usuario"]) || $fila["privilegios"] != 1 )
						{
							$salida .= '
							<a class="e1" href="?id_usuario='.$fila['id_usuario'].'" data-accion="ver_detalles" data-toggle="ver_detalles">
								<i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
							</a>
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
								<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
							</a>
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="eliminar" data-toggle="eliminar_usuario">
								<i class="glyphicon glyphicon-trash" title="Eliminar"></i>
							</a>
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="modificar" data-toggle="actualizar_usuario"
								dbd_clave="'.$fila['clave'].'" dbd_nombre="'.$fila['nombre'].'" dbd_priv="'.$fila['privilegios'].'"
								dbd_max="'.$fila['max'].'" dbd_susc_tipo="'.$fila['suscripcion_tipo'].'"
								dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'" dbd_susc_dias="'.$fila['suscripcion_dias'].'" >
								<i class="glyphicon glyphicon-edit" title="Modificar"></i>
							</a>';
						}
					}
					else if ( $_SESSION["tipo_usuario"] == 2 )
					{
						if ( ($fila["id_usuario"] == $_SESSION["id_usuario"])
							|| ($_SESSION["id_usuario"] == $fila["id_administrador"]) )
						{
							$salida .= '
							<a class="e1" href="?id_usuario='.$fila['id_usuario'].'" data-accion="ver_detalles" data-toggle="ver_detalles">
								<i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
							</a>
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
								<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
							</a>';
							if ( $fila["privilegios"] > 2 )
							{
								$salida .= '
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="eliminar" data-toggle="eliminar_usuario">
									<i class="glyphicon glyphicon-trash" title="Eliminar"></i>
								</a>';
							}
							$salida .= '
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="modificar" data-toggle="actualizar_usuario"
									dbd_clave="'.$fila['clave'].'" dbd_nombre="'.$fila['nombre'].'" dbd_priv="'.$fila['privilegios'].'"
									dbd_max="'.$fila['max'].'"	dbd_susc_tipo="'.$fila['suscripcion_tipo'].'"
									dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'" dbd_susc_dias="'.$fila['suscripcion_dias'].'" >
									<i class="glyphicon glyphicon-edit" title="Modificar"></i>
								</a>';
						}
					}
					$salida .= '
							</div>';
							if ($_SESSION["tipo_usuario"] == 1)
							{
								if ( ($fila["id_usuario"] == $_SESSION["id_usuario"]) || ($fila["privilegios"] != 1) )
									$salida .= '
										<input type="checkbox" name="my-checkbox" class="bootstrap-switch-mini" value="'.$fila['id_usuario'].'" checked>';
							}
							else if ( !($_SESSION["tipo_usuario"] == 2 && $fila["privilegios"] == 2) )
							{
								$salida .= '
									<input type="checkbox" name="my-checkbox" class="bootstrap-switch-mini" value="'.$fila['id_usuario'].'" checked>';
							}
						$salida .= '</td>
					</tr>';
			}

			$salida .= '
					</tbody>
				</table>
			</div>';

			if ($total_paginas > 1) {
				$salida .= '<div style="clear:left;text-align:center"><ul class="pagination">';
				if ($pag_num != 1) {
					$salida .= '<li><a href="../cl/desc.php?pag=1" class="paginate" style="cursor:pointer" title="Primero">&laquo;</a></li><li><a href="../cl/desc.php?pag='.($pag_num-1).'" class="paginate" style="cursor:pointer" title="Anterior">&#8249;</a></li>';
				}
				$salida .= '<li><a class="paginate2">Página '.$pag_num.' de '.$total_paginas.'</a></li>';
				if ($pag_num != $total_paginas) {
					$salida .= '<li><a href="../cl/desc.php?pag='.($pag_num+1).'" class="paginate" style="cursor:pointer" title="Siguiente">&#8250;</a></li><li><a href="../cl/desc.php?pag='.$total_paginas.'" class="paginate" style="cursor:pointer" title="Último">&raquo;</a></li>';
				}
				$salida .= '</ul></div>';
			}
		}
		else{
			$salida .= '
				<div class="subtitulo">
					<p>Usuarios desconectados <span class="badge">0</span></p>
				</div>
				<div class="col-lg-12 subtitulo2">No hay usuarios desconectados.</div>
			';
		}
	}
	return $salida;
}

function cargar_suspendidos($pag_num) {
	global $conexion;
	if (isset($_GET['id_usuario']))
	{
		if ($_SESSION["tipo_usuario"] == 1)
		{
			$consulta_ver = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo,
				suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo,
				suscripcion.fecha AS suscripcion_fecha, suscripcion.dias AS suscripcion_dias,
				suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
				FROM registrados
				LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
				LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
				WHERE (registrados.privilegios != 1 AND registrados.status = 1 AND registrados.id_usuario = '".$_GET['id_usuario']."')";

			$consulta_ver2 = "SELECT direccion_ip, fecha, actividad
				FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario
				WHERE (registrados.privilegios != 1 AND entradas.usuario_id = '".$_GET['id_usuario']."' AND registrados.status = 1)
				ORDER BY entradas.fecha DESC LIMIT 0,10";
		}
		else if ($_SESSION["tipo_usuario"] == 2)
		{
			$consulta_ver = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.fecha AS suscripcion_fecha, suscripcion.dias AS suscripcion_dias FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status = 1 AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') AND registrados.id_usuario = '".$_GET['id_usuario']."'";
			$consulta_ver2 = "SELECT direccion_ip, fecha, actividad FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario WHERE registrados.status = 1 AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') AND entradas.usuario_id = '".$_GET['id_usuario']."' ORDER BY entradas.fecha DESC LIMIT 0,10";
		}
		$salida = ver_detalles($_GET['id_usuario'], $consulta_ver, $consulta_ver2, "susp");
	}else if (isset($_GET['buscar'])) {
		if ($_SESSION["tipo_usuario"] == 1) {
			$consulta_buscar = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2 FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status = 1 AND registrados.nombre LIKE '%".$_GET['buscar']."%' ORDER BY registrados.privilegios ASC";
		}else if ($_SESSION["tipo_usuario"] == 2) {
			$consulta_buscar = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status = 1 AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') AND (registrados.nombre LIKE '%".$_GET['buscar']."%') ORDER BY registrados.privilegios ASC";
		}
		$salida = buscar($_GET['buscar'], $consulta_buscar, "susp");
	}else {
		$salida = '
			<div class="barra-botones">
				<div class="container-fluid">
					<div class="contenedor-botones">
						<button class="btn btn-info" title="Actualizar" data-toggle="actualizar" data-accion="actualizar_suspendidos" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i></button>
						<button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="guardar" data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i></button>
						<div class="btn-group2">
							<button type="button" class="btn btn-info" data-accion="eliminar_array" data-toggle="confirmar" title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i></button>
							<button type="button" class="btn btn-info" data-accion="renaudar" data-toggle="confirmar" title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i></button>
							<button type="button" class="btn btn-info" data-accion="reestablecer_array" data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom"><i class="glyphicon glyphicon-repeat"></i></button>
						</div>
					</div>
					<div class="buscar">
						<input type="text" id="campo_busqueda" placeholder="Buscar usuario">
						<a href="#" class="abrir-buscar"><i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i></a>
					</div>
				</div>
			</div>
		';
		if ($_SESSION["tipo_usuario"] == 1) {
			$restriccion2 = "";
			$restriccion1 = "";
		}else if ($_SESSION["tipo_usuario"] == 2) {
			$restriccion2 = " AND (id_usuario = '".$_SESSION['id_usuario']."' || id_administrador = '".$_SESSION['id_usuario']."')";
			$restriccion1 = " AND (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."')";
		}
		$queryConsulta2 = mysqli_query($conexion, "SELECT * FROM registrados WHERE status  = 1 $restriccion2");
		$totalFilas = mysqli_num_rows($queryConsulta2);
		if($totalFilas > 0) {
			$filas_pagina = 24;
			$total_paginas = ceil($totalFilas/$filas_pagina);
			if (isset($_GET['pag'])) {
				$pag_num = $_GET['pag'];
			}else {
				if ($pag_num != 1) {
					$pag_num = ($pag_num > $total_paginas) ? $pag_num - 1 : $pag_num;
				}else {
					$pag_num = $pag_num;
				}
			}
			$offset = ($pag_num - 1) * $filas_pagina;
			$queryConsulta = mysqli_query($conexion, "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2 FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.status = 1 $restriccion1 ORDER BY registrados.privilegios ASC LIMIT $offset, $filas_pagina");
			$privilegios = array(
				"" => "0",
				"1" => "Super administrador",
				"2" => "Administrador",
				"3" => "Nacionales",
				"4" => "Americanas",
				"5" => "Americanas-Nacionales",
				"6" => "Television"
			);
			$salida .= '
				<div class="subtitulo">
					<p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos" data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i></a> Usuarios suspendidos <span class="badge" style="background-color:#434343">'.$totalFilas.'</span></p>
				</div>
			';

			$salida .= '
			<div class="table-responsive">
				<table class="table table-usuarios">
					<thead>
						<tr>
							<th>Usuario</th>
							<th>Dirección IP</th>
							<th>Privilegios</th>
							<th>Status</th>
							<th>Acciones</th>
						</tr>
					</thead>
					<tbody>
			';

			while( $fila = mysqli_fetch_assoc($queryConsulta) )
			{
				$salida .= '
				<tr>
					<td>
						'.$fila["nombre"].
						estado(
							$fila["online"], $fila["status"], $fila["status2"],
							$fila["suscripcion_status"], $fila["suscripcion_status2"]
						).'
					</td>
					<td>'.$fila["ip"].'</td>
					<td>'.$privilegios[ $fila['privilegios'] ].'</td>
					<td>Suspendido</td>';

					$salida .='
					<td>
						<div class="acciones">';

					if ( $_SESSION["tipo_usuario"] == 1 )
					{
						if ( ($fila["id_usuario"] == $_SESSION["id_usuario"]) || $fila["privilegios"] != 1 )
						{
							$salida .= '
							<a class="e1" href="?id_usuario='.$fila['id_usuario'].'" data-accion="ver_detalles" data-toggle="ver_detalles">
								<i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
							</a>
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
								<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
							</a>
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="eliminar" data-toggle="eliminar_usuario">
								<i class="glyphicon glyphicon-trash" title="Eliminar"></i>
							</a>
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="modificar" data-toggle="actualizar_usuario"
								dbd_clave="'.$fila['clave'].'" dbd_nombre="'.$fila['nombre'].'" dbd_priv="'.$fila['privilegios'].'"
								dbd_max="'.$fila['max'].'" dbd_susc_tipo="'.$fila['suscripcion_tipo'].'"
								dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'" dbd_susc_dias="'.$fila['suscripcion_dias'].'" >
								<i class="glyphicon glyphicon-edit" title="Modificar"></i>
							</a>';
						}
					}
					else if ( $_SESSION["tipo_usuario"] == 2 )
					{
						if ( ($fila["id_usuario"] == $_SESSION["id_usuario"])
							|| ($_SESSION["id_usuario"] == $fila["id_administrador"]) )
						{
							$salida .= '
							<a class="e1" href="?id_usuario='.$fila['id_usuario'].'" data-accion="ver_detalles" data-toggle="ver_detalles">
								<i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
							</a>
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
								<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
							</a>';
							if ( $fila["privilegios"] > 2 )
							{
								$salida .= '
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="eliminar" data-toggle="eliminar_usuario">
									<i class="glyphicon glyphicon-trash" title="Eliminar"></i>
								</a>';
							}
							$salida .= '
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="modificar" data-toggle="actualizar_usuario"
									dbd_clave="'.$fila['clave'].'" dbd_nombre="'.$fila['nombre'].'" dbd_priv="'.$fila['privilegios'].'"
									dbd_max="'.$fila['max'].'" dbd_susc_tipo="'.$fila['suscripcion_tipo'].'"
									dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'" dbd_susc_dias="'.$fila['suscripcion_dias'].'" >
									<i class="glyphicon glyphicon-edit" title="Modificar"></i>
								</a>';
						}
					}
					$salida .= '
							</div>';
							if ($_SESSION["tipo_usuario"] == 1)
							{
								if ( ($fila["id_usuario"] == $_SESSION["id_usuario"]) || ($fila["privilegios"] != 1) )
									$salida .= '
										<input type="checkbox" name="my-checkbox" class="bootstrap-switch-mini" value="'.$fila['id_usuario'].'" checked>';
							}
							else if ( !($_SESSION["tipo_usuario"] == 2 && $fila["privilegios"] == 2) )
							{
								$salida .= '
									<input type="checkbox" name="my-checkbox" class="bootstrap-switch-mini" value="'.$fila['id_usuario'].'" checked>';
							}
						$salida .= '</td>
					</tr>';
			} #fin while

			$salida .= '
					</tbody>
				</table>
			</div>';

			if ($total_paginas > 1) {
				$salida .= '<div style="clear:left;text-align:center"><ul class="pagination">';
				if ($pag_num != 1) {
					$salida .= '<li><a href="../cl/susp.php?pag=1" class="paginate" style="cursor:pointer" title="Primero">&laquo;</a></li><li><a href="../cl/susp.php?pag='.($pag_num-1).'" class="paginate" style="cursor:pointer" title="Anterior">&#8249;</a></li>';
				}
				$salida .= '<li><a class="paginate2">Página '.$pag_num.' de '.$total_paginas.'</a></li>';
				if ($pag_num != $total_paginas) {
					$salida .= '<li><a href="../cl/susp.php?pag='.($pag_num+1).'" class="paginate" style="cursor:pointer" title="Siguiente">&#8250;</a></li><li><a href="../cl/susp.php?pag='.$total_paginas.'" class="paginate" style="cursor:pointer" title="Último">&raquo;</a></li>';
				}
				$salida .= '</ul></div>';
			}
		}
		else
		{
			$salida .= '
				<div class="subtitulo">
					<p>Usuarios suspendidos <span class="badge" style="background-color:#434343">0</span></p>
				</div>
				<div class="col-lg-12 subtitulo2">No hay usuarios suspendidos.</div>
			';
		}
	}
	return $salida;
}

function cargar_todos($pag_num) {
	global $conexion;
	if (isset($_GET['id_usuario']))
	{
		if ($_SESSION["tipo_usuario"] == 1)
		{
			if ($_SESSION["id_usuario"] == $_GET['id_usuario'])
			{
				$consulta_ver = "SELECT registrados.* FROM registrados
					WHERE (registrados.id_usuario = '".$_SESSION['id_usuario']."')";

				$consulta_ver2 = "SELECT direccion_ip, fecha, actividad
					FROM entradas WHERE (entradas.usuario_id = '".$_GET['id_usuario']."')
					ORDER BY entradas.fecha DESC LIMIT 0,10";
			}
			else
			{
				$consulta_ver = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo,
					suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.fecha AS suscripcion_fecha,
					suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
					FROM registrados
					LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
					LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
					WHERE (registrados.privilegios != 1 AND registrados.id_usuario = '".$_GET['id_usuario']."')";

				$consulta_ver2 = "SELECT direccion_ip, fecha, actividad
					FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario
					WHERE (registrados.privilegios != 1 AND entradas.usuario_id = '".$_GET['id_usuario']."')
					ORDER BY entradas.fecha DESC LIMIT 0,10";
			}
		}
		else if ($_SESSION["tipo_usuario"] == 2)
		{
			$consulta_ver = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.fecha AS suscripcion_fecha, suscripcion.dias AS suscripcion_dias FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') AND registrados.id_usuario = '".$_GET['id_usuario']."'";

			$consulta_ver2 = "SELECT direccion_ip, fecha, actividad FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario WHERE (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') AND entradas.usuario_id = '".$_GET['id_usuario']."' ORDER BY entradas.fecha DESC LIMIT 0,10";
		}
		$salida = ver_detalles($_GET['id_usuario'], $consulta_ver, $consulta_ver2, "todos");
	}
	else if (isset($_GET['buscar']))
	{
		if ($_SESSION["tipo_usuario"] == 1) {
			$consulta_buscar = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2 FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE registrados.nombre LIKE '%".$_GET['buscar']."%' ORDER BY registrados.privilegios ASC";
		}
		else if ($_SESSION["tipo_usuario"] == 2) {
			$consulta_buscar = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario WHERE (registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."') AND (registrados.nombre LIKE '%".$_GET['buscar']."%') ORDER BY registrados.privilegios ASC";
		}
		$salida = buscar($_GET['buscar'], $consulta_buscar, "todos");
	}else {
		$salida = '
			<div class="barra-botones">
				<div class="container-fluid">
					<div class="contenedor-botones">
						<button class="btn btn-info" title="Actualizar" data-toggle="actualizar" data-accion="actualizar_todos" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i></button>
						<button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="guardar" data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i></button>
						<div class="btn-group2">
							<button type="button" class="btn btn-info" data-accion="eliminar_array" data-toggle="confirmar" title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i></button>
							<button type="button" class="btn btn-info" data-accion="susp_todos" data-toggle="confirmar" title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i></button>
							<button type="button" class="btn btn-info" data-accion="renaudar_todos" data-toggle="confirmar" title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i></button>
							<button type="button" class="btn btn-info" data-accion="reestablecer_array" data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom"><i class="glyphicon glyphicon-repeat"></i></button>
						</div>
					</div>
					<div class="buscar">
						<input type="text" id="campo_busqueda" placeholder="Buscar usuario">
						<a href="#" class="abrir-buscar"><i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i></a>
					</div>
				</div>
			</div>
		';
		if ($_SESSION["tipo_usuario"] == 1) {
			$restriccion2 = "";
			$restriccion1 = "";
		}else if ($_SESSION["tipo_usuario"] == 2) {
			$restriccion2 = " WHERE id_usuario = '".$_SESSION['id_usuario']."' || id_administrador = '".$_SESSION['id_usuario']."'";
			$restriccion1 = " WHERE registrados.id_usuario = '".$_SESSION['id_usuario']."' || registrados.id_administrador = '".$_SESSION['id_usuario']."'";
		}
		$queryConsulta2 = mysqli_query($conexion, "SELECT * FROM registrados $restriccion2");
		$totalFilas = mysqli_num_rows($queryConsulta2);
		if($totalFilas > 0) {
			$filas_pagina = 24;
			$total_paginas = ceil($totalFilas/$filas_pagina);
			if (isset($_GET['pag'])) {
				$pag_num = $_GET['pag'];
			}else {
				if ($pag_num != 1)
					$pag_num = ($pag_num > $total_paginas) ? $pag_num - 1 : $pag_num;
				else
					$pag_num = $pag_num;
			}
			$offset = ($pag_num - 1) * $filas_pagina;
			$queryConsulta = mysqli_query($conexion, "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo, suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias, suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2 FROM registrados LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario $restriccion1 ORDER BY registrados.privilegios ASC LIMIT $offset, $filas_pagina");
			$privilegios = array(
				"" => "0",
				"1" => "Super administrador",
				"2" => "Administrador",
				"3" => "Nacionales",
				"4" => "Americanas",
				"5" => "Americanas-Nacionales",
				"6" => "Television"
			);
			$status  = array(0 => "Activo", 1 => "Suspendido", 2 => "Activo");
			$salida .= '
				<div class="subtitulo">
					<p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos" data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i></a> Todos los usuarios <span class="badge" style="background-color:#5bc0de">'.$totalFilas.'</span></p>
				</div>
			';

			$salida .= '
			<div class="table-responsive">
				<table class="table table-usuarios">
					<thead>
						<tr>
							<th>Usuario</th>
							<th>Dirección IP</th>
							<th>Privilegios</th>
							<th>Status</th>
							<th>Acciones</th>
						</tr>
					</thead>
					<tbody>
			';

			while( $fila = mysqli_fetch_assoc($queryConsulta) )
			{
				if ($fila['status'] == '1') {
					$checked = "checked";
					$name = "my-checkbox-todos1";
				}
				else {
					$checked = "";
					$name = "my-checkbox-todos2";
				}

				$salida .= '
				<tr>
					<td>
						'.$fila["nombre"].
						estado(
							$fila["online"], $fila["status"], $fila["status2"],
							$fila["suscripcion_status"], $fila["suscripcion_status2"]
						).'
					</td>
					<td>'.$fila["ip"].'</td>
					<td>'.$privilegios[ $fila['privilegios'] ].'</td>
					<td>'.$status[ $fila["status"] ].'</td>';

					$salida .='
					<td>
						<div class="acciones">';

					if ( $_SESSION["tipo_usuario"] == 1 )
					{
						if ( ($fila["id_usuario"] == $_SESSION["id_usuario"]) || $fila["privilegios"] != 1 )
						{
							$salida .= '
								<a class="e1" href="?id_usuario='.$fila['id_usuario'].'" data-accion="ver_detalles" data-toggle="ver_detalles">
									<i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
								</a>
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
									<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
								</a>
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="eliminar" data-toggle="eliminar_usuario">
									<i class="glyphicon glyphicon-trash" title="Eliminar"></i>
								</a>
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="modificar" data-toggle="actualizar_usuario"
									dbd_clave="'.$fila['clave'].'" dbd_nombre="'.$fila['nombre'].'" dbd_priv="'.$fila['privilegios'].'"
									dbd_max="'.$fila['max'].'" dbd_susc_tipo="'.$fila['suscripcion_tipo'].'"
									dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'" dbd_susc_dias="'.$fila['suscripcion_dias'].'" >
									<i class="glyphicon glyphicon-edit" title="Modificar"></i>
								</a>';
						}
					}
					else if ( $_SESSION["tipo_usuario"] == 2 )
					{
						if ( ($fila["id_usuario"] == $_SESSION["id_usuario"])
							|| ($_SESSION["id_usuario"] == $fila["id_administrador"]) )
						{
							$salida .= '
							<a class="e1" href="?id_usuario='.$fila['id_usuario'].'" data-accion="ver_detalles" data-toggle="ver_detalles">
								<i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
							</a>
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
								<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
							</a>';
							if ( $fila["privilegios"] > 2 )
							{
								$salida .= '
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="eliminar" data-toggle="eliminar_usuario">
									<i class="glyphicon glyphicon-trash" title="Eliminar"></i>
								</a>';
							}
						}
						$salida .= '
							<a class="e1" href="'.$fila['id_usuario'].'" data-accion="modificar" data-toggle="actualizar_usuario"
								dbd_clave="'.$fila['clave'].'" dbd_nombre="'.$fila['nombre'].'" dbd_priv="'.$fila['privilegios'].'"
								dbd_max="'.$fila['max'].'" dbd_susc_tipo="'.$fila['suscripcion_tipo'].'"
								dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'" dbd_susc_dias="'.$fila['suscripcion_dias'].'" >
								<i class="glyphicon glyphicon-edit" title="Modificar"></i>
							</a>';
					}
					$salida .= '
							</div>';
							if ($_SESSION["tipo_usuario"] == 1)
							{
								if ( ($fila["id_usuario"] == $_SESSION["id_usuario"]) || ($fila["privilegios"] != 1) )
									$salida .= '
										<input type="checkbox" name="'.$name.'" class="bootstrap-switch-mini" value="'.$fila['id_usuario'].'" checked>';
							}
							else if ( !($_SESSION["tipo_usuario"] == 2 && $fila["privilegios"] == 2) )
							{
								$salida .= '
									<input type="checkbox" name="'.$name.'" class="bootstrap-switch-mini" value="'.$fila['id_usuario'].'" checked>';
							}
						$salida .= '</td>
					</tr>';
			} #fin while

			$salida .= '
					</tbody>
				</table>
			</div>';

			if ($total_paginas > 1) {
				$salida .= '<div style="clear:left;text-align:center"><ul class="pagination">';
				if ($pag_num != 1) {
					$salida .= '<li><a href="../cl/todos.php?pag=1" class="paginate" style="cursor:pointer" title="Primero">&laquo;</a></li><li><a href="../cl/todos.php?pag='.($pag_num-1).'" class="paginate" style="cursor:pointer" title="Anterior">&#8249;</a></li>';
				}
				$salida .= '<li><a class="paginate2">Página '.$pag_num.' de '.$total_paginas.'</a></li>';
				if ($pag_num != $total_paginas) {
					$salida .= '<li><a href="../cl/todos.php?pag='.($pag_num+1).'" class="paginate" style="cursor:pointer" title="Siguiente">&#8250;</a></li><li><a href="../cl/todos.php?pag='.$total_paginas.'" class="paginate" style="cursor:pointer" title="Último">&raquo;</a></li>';
				}
				$salida .= '</ul></div>';
			}
		}
		else{
			$salida .= '
				<div class="subtitulo">
					<p>Todos los usuarios <span class="badge" style="background-color:#5bc0de">'.$totalFilas.'</span></p>
				</div>
				<div class="col-lg-12 subtitulo2">No hay usuarios registrados.</div>
			';
		}
	}
	return $salida;
}

function mis_usuarios($pag_num) {
	global $conexion;
	if (isset($_GET['id_usuario']))
	{
		$consulta_ver = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo,
			suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
			suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
			FROM registrados
			JOIN usuarios_superadmin ON registrados.id_usuario = usuarios_superadmin.id_usuario_creado
			LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
			LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
			WHERE	(usuarios_superadmin.id_usuario_creado = '".$_GET['id_usuario']."' AND
				usuarios_superadmin.id_superadmin = '".$_SESSION['id_usuario']."')";

		$consulta_ver2 = "SELECT direccion_ip, fecha, actividad
			FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario
			WHERE (entradas.usuario_id = '".$_GET['id_usuario']."')
			ORDER BY entradas.fecha DESC LIMIT 0,10";

		$salida = ver_detalles($_GET['id_usuario'], $consulta_ver, $consulta_ver2, "mis_usuarios");
	}
	else if (isset($_GET['buscar']))
	{
		$consulta_buscar = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo,
			suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
			suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
			FROM registrados
			JOIN usuarios_superadmin ON registrados.id_usuario = usuarios_superadmin.id_usuario_creado
			LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
			LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
			WHERE (registrados.nombre LIKE '%".$_GET['buscar']."%' AND usuarios_superadmin.id_superadmin = '".$_SESSION['id_usuario']."')
			ORDER BY registrados.privilegios ASC";
		$salida = buscar($_GET['buscar'], $consulta_buscar, "mis_usuarios");
	}
	else
	{
		$salida = '
			<div class="barra-botones">
				<div class="container-fluid">
					<div class="contenedor-botones">
						<button class="btn btn-info" title="Actualizar" data-toggle="actualizar" data-accion="actualizar_mis_usuarios" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i></button>
						<button class="btn btn-info" title="Nuevo usuario" data-toggle="modal" data-accion="guardar" data-placement="bottom"><i class="glyphicon glyphicon-plus-sign"></i></button>
						<div class="btn-group2">
							<button type="button" class="btn btn-info" data-accion="eliminar_array" data-toggle="confirmar" title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i></button>
							<button type="button" class="btn btn-info" data-accion="susp_todos" data-toggle="confirmar" title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i></button>
							<button type="button" class="btn btn-info" data-accion="renaudar_todos" data-toggle="confirmar" title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i></button>
							<button type="button" class="btn btn-info" data-accion="reestablecer_array" data-toggle="confirmar" title="Restablecer pregunta de seguridad" data-placement="bottom"><i class="glyphicon glyphicon-repeat"></i></button>
						</div>
					</div>
					<div class="buscar">
						<input type="text" id="campo_busqueda" placeholder="Buscar usuario">
						<a href="#" class="abrir-buscar"><i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i></a>
					</div>
				</div>
			</div>
		';
		$sql_consulta2 = 'SELECT * FROM usuarios_superadmin
			JOIN registrados ON registrados.id_usuario = usuarios_superadmin.id_usuario_creado
			WHERE	usuarios_superadmin.id_superadmin = "'.$_SESSION['id_usuario'].'"';
		$queryConsulta2 = mysqli_query($conexion, $sql_consulta2);
		$totalFilas = mysqli_num_rows($queryConsulta2);
		if($totalFilas > 0) {
			$filas_pagina = 24;
			$total_paginas = ceil($totalFilas/$filas_pagina);
			if (isset($_GET['pag'])) {
				$pag_num = $_GET['pag'];
			}else {
				if ($pag_num != 1)
					$pag_num = ($pag_num > $total_paginas) ? $pag_num - 1 : $pag_num;
				else
					$pag_num = $pag_num;
			}
			$offset = ($pag_num - 1) * $filas_pagina;
			$sql_consulta = "SELECT registrados.*, conteo_administradores.max, suscripcion.tiempo AS suscripcion_tiempo,
				suscripcion.tiempo2 AS suscripcion_tiempo2, suscripcion.tipo AS suscripcion_tipo, suscripcion.dias AS suscripcion_dias,
				suscripcion.status AS suscripcion_status, suscripcion.status2 AS suscripcion_status2
				FROM registrados
				JOIN usuarios_superadmin ON registrados.id_usuario = usuarios_superadmin.id_usuario_creado
				LEFT JOIN conteo_administradores ON registrados.id_usuario = conteo_administradores.id_administrador
				LEFT JOIN suscripcion ON suscripcion.id_usuario = registrados.id_usuario
				WHERE	usuarios_superadmin.id_superadmin = '".$_SESSION['id_usuario']."'
				ORDER BY registrados.privilegios ASC LIMIT $offset, $filas_pagina";
			$queryConsulta = mysqli_query($conexion, $sql_consulta);
			$privilegios = array(
				"" => "0",
				"1" => "Super administrador",
				"2" => "Administrador",
				"3" => "Nacionales",
				"4" => "Americanas",
				"5" => "Americanas-Nacionales",
				"6" => "Television"
			);
			$status  = array(0 => "Activo", 1 => "Suspendido", 2 => "Activo");
			$salida .= '
				<div class="subtitulo">
					<p><a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos" data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i></a> Mis usuarios <span class="badge" style="background-color:#5bc0de">'.$totalFilas.'</span></p>
				</div>
			';

			$salida .= '
			<div class="table-responsive">
				<table class="table table-usuarios">
					<thead>
						<tr>
							<th>Usuario</th>
							<th>Contraseña</th>
							<th>Dirección IP</th>
							<th>Privilegios</th>
							<th>Status</th>
							<th>Acciones</th>
						</tr>
					</thead>
					<tbody>
			';

			while( $fila = mysqli_fetch_assoc($queryConsulta) )
			{
				if ($fila['status'] == '1') {
					$checked = "checked";
					$name = "my-checkbox-todos1";
				}
				else {
					$checked = "";
					$name = "my-checkbox-todos2";
				}

				$salida .= '
				<tr>
					<td>
						'.$fila["nombre"].
						estado(
							$fila["online"], $fila["status"], $fila["status2"],
							$fila["suscripcion_status"], $fila["suscripcion_status2"]
						).'
					</td>
					<td>'.$fila["clave"].'</td>
					<td>'.$fila["ip"].'</td>
					<td>'.$privilegios[ $fila['privilegios'] ].'</td>
					<td>'.$status[ $fila["status"] ].'</td>';

					$salida .='
						<td>
							<div class="acciones">
								<a class="e1" href="?id_usuario='.$fila['id_usuario'].'" data-accion="ver_detalles" data-toggle="ver_detalles">
									<i class="glyphicon glyphicon-list-alt" title="Ver detalles"></i>
								</a>
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="rest_ip" data-toggle="reiniciar_ip">
									<i class="glyphicon glyphicon-repeat" title="Restablecer pregunta de seguridad"></i>
								</a>
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="eliminar" data-toggle="eliminar_usuario">
									<i class="glyphicon glyphicon-trash" title="Eliminar"></i>
								</a>
								<a class="e1" href="'.$fila['id_usuario'].'" data-accion="modificar" data-toggle="actualizar_usuario"
									dbd_clave="'.$fila['clave'].'" dbd_nombre="'.$fila['nombre'].'" dbd_priv="'.$fila['privilegios'].'"
									dbd_max="'.$fila['max'].'" dbd_susc_tipo="'.$fila['suscripcion_tipo'].'"
									dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'" dbd_susc_dias="'.$fila['suscripcion_dias'].'" >
									<i class="glyphicon glyphicon-edit" title="Modificar"></i>
								</a>
							</div>
							<input type="checkbox" name="'.$name.'" class="bootstrap-switch-mini" value="'.$fila['id_usuario'].'" checked>
						</td>
					</tr>';
			} #fin while

			$salida .= '
					</tbody>
				</table>
			</div>';

			if ($total_paginas > 1) {
				$salida .= '<div style="clear:left;text-align:center"><ul class="pagination">';
				if ($pag_num != 1) {
					$salida .= '<li><a href="../cl/todos.php?pag=1" class="paginate" style="cursor:pointer" title="Primero">&laquo;</a></li><li><a href="../cl/todos.php?pag='.($pag_num-1).'" class="paginate" style="cursor:pointer" title="Anterior">&#8249;</a></li>';
				}
				$salida .= '<li><a class="paginate2">Página '.$pag_num.' de '.$total_paginas.'</a></li>';
				if ($pag_num != $total_paginas) {
					$salida .= '<li><a href="../cl/todos.php?pag='.($pag_num+1).'" class="paginate" style="cursor:pointer" title="Siguiente">&#8250;</a></li><li><a href="../cl/todos.php?pag='.$total_paginas.'" class="paginate" style="cursor:pointer" title="Último">&raquo;</a></li>';
				}
				$salida .= '</ul></div>';
			}
		}
		else{
			$salida .= '
				<div class="subtitulo">
					<p>Mis usuarios <span class="badge" style="background-color:#5bc0de">'.$totalFilas.'</span></p>
				</div>
				<div class="col-lg-12 subtitulo2">No has creado ningún usuario todavía.</div>
			';
		}
	}
	return $salida;
}

function cargar_notificaciones() {
	global $conexion;
	$actividad = array(
		1 => "Inició sesión por primera vez con el número de IP: ",
		2 => "Inició sesión con nuevo número de IP: ",
		3=> "Inició sesión",
		4 => "Intentó iniciar sesión con un número de IP diferente: ",
		5 => "Intentó iniciar sesión con la cuenta suspendida",
		#6 => "Inició sesión por primera vez con una conexión eventual",
		7  => "Pregunta de seguridad restablecida",
		#7 => "IP restablecida",
		8 => "Intento fallido de conexión simultánea",
		9 => "La suscripción ha caducado",
		10 => "Intentó iniciar sesión con la suscripción caducada",
		11 => "Suscripción renovada",
		12 => "Intentó iniciar sesión con suscripción semanal inválida",
		13 => "Intentó iniciar sesión con suscripción de administrador caducada",
		14 => "Intentó iniciar sesión con la cuenta de administrador suspendida");
	$actividad_list = array(1 => "list-group-item", 2 => "list-group-item", 3 => 'list-group-item', 4 => "list-group-item list-group-item-warning", 5 => "list-group-item list-group-item-warning", 6 => "list-group-item", 7 => "list-group-item", 8 => "list-group-item list-group-item-warning", 9 => "list-group-item list-group-item-success", 10 => "list-group-item list-group-item-warning", 11 => "list-group-item", 12 => "list-group-item list-group-item-warning", 13 => "list-group-item list-group-item-warning", 14 => "list-group-item list-group-item-warning");
	$salida = '
		<div class="barra-botones">
			<div class="container-fluid">
				<div class="contenedor-botones">
					<button class="btn btn-info" data-toggle="" title="Volver" data-placement="bottom" onClick="history.go(-1)"><i class="glyphicon glyphicon-arrow-left"></i></button>
					<button class="btn btn-info" title="Actualizar" data-toggle="actualizar" data-placement="bottom"><i class="glyphicon glyphicon-refresh"></i></button>
					';
					if ($_SESSION['tipo_usuario'] == 1) {
						$salida .= '<div class="btn-group">
							<button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-expanded="false" title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i></button>
						  	<ul class="dropdown-menu" role="menu">
							    <li><a href="#" data-toggle="eliminar" data-accion="hoy">Últimas 24 horas</a></li>
							    <li><a href="#" data-toggle="eliminar" data-accion="semana">Última semana</a></li>
							    <li><a href="#" data-toggle="eliminar" data-accion="mes">Último mes</a></li>
							    <li><a href="#" data-toggle="eliminar" data-accion="anio">Último año</a></li>
							    <li class="divider"></li>
							    <li><a href="#" data-toggle="eliminar" data-accion="todo">Todas</a></li>
						  	</ul>
						  	</div>
						';
					}
					$salida .= '</div>
			</div>
		</div>
	';
	$salida .= '
		<div class="col-xs-12 col-sm-8 col-sm-offset-2 col-md-8 col-md-offset-2 col-lg-6 col-lg-offset-3" >
			<div class="panel panel-info">
				<div class="panel-heading">
					<h3 class="panel-title">Historial de notificaciones</h3>
				</div>';

				if ($_SESSION['tipo_usuario'] == 1)
					$query_consulta = mysqli_query($conexion, "SELECT entradas.*, registrados.nombre FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario WHERE entradas.actividad <> 3 ORDER BY fecha DESC LIMIT 0,10");
				else if ($_SESSION['tipo_usuario'] == 2)
					$query_consulta = mysqli_query($conexion, "SELECT entradas.*, registrados.nombre FROM entradas JOIN registrados ON entradas.usuario_id = registrados.id_usuario WHERE registrados.id_administrador = '".$_SESSION['id_usuario']."' AND entradas.actividad <> 3 ORDER BY fecha DESC LIMIT 0,10");

				if (mysqli_num_rows($query_consulta) > 0) {
					$salida .= '<ul class="list-group">';
					while ($fila_entradas = mysqli_fetch_array($query_consulta)) {
						$salida .= '
							<li class="'.$actividad_list[$fila_entradas['actividad']].'">
								<a href="todos.php?id_usuario='.$fila_entradas['usuario_id'].'"><i class="glyphicon glyphicon-user"></i> '.$fila_entradas['nombre'].'</a>
								<span style="font-weight:bold;float:right"> '.date("d/m/Y",$fila_entradas['fecha']).'</span>';
								if ($fila_entradas['actividad'] == 3) {
									$salida .= '<p class="list-group-item-text"><span style="float:right;color:#8899A6;font-size:12px;font-weight:bold">'.date("h:i:s a",$fila_entradas['fecha']).'</span> '.$actividad[$fila_entradas['actividad']].'</p>';
								}else {
									$salida .= '<p class="list-group-item-text"><span style="float:right;color:#8899A6;font-size:12px;font-weight:bold">'.date("h:i:s a",$fila_entradas['fecha']).'</span> '.$actividad[$fila_entradas['actividad']].''.$fila_entradas['direccion_ip'].'</p>';
								}
						$salida .= '</li>';
					}
					$salida .= '
						</ul>
							<div id="cargar_entradas_footer" class="panel-footer" style="border-top:none;text-align:center">
								<span style="font-weight:bold;color:#5bc0de">...</span>
							</div>
					';
				}else {
					$salida .= '
						<div class="panel-body">
							No hay notificaciones hasta los momentos.
						</div>
					';
				}
		$salida .= '</div> </div> </div>';
	return $salida;
}

function eliminar_online($id_usuario, $tiempo) {
	global $conexion;
	mysqli_query($conexion, "UPDATE registrados SET online = '0', tiempo = '$tiempo' WHERE id_usuario = '$id_usuario'");
}

function estado($online, $status, $status2, $status_suscripcion, $status_suscripcion2) {
	if ($online == 1)
		$salida_estado = "<h3 class='estado glyphicon glyphicon-asterisk' title='En línea' data-placement='bottom' style='color:#f0ad4e;font-size:12px'></h3>";
	else {
		if ($status == 1)
			$salida_estado = "<h3 class='estado glyphicon glyphicon-minus' title='Suspendido' data-placement='bottom' style='color:#434343;font-size:14px'></h3>";
		//else {
			if ($status2 == 1)
				$salida_estado .= "<h3 class='estado glyphicon glyphicon-minus-sign' title='Administrador suspendido' data-placement='bottom' style='color:#616161;font-size:14px'></h3>";
			//else {
				if ($status_suscripcion == 1)
					$salida_estado .= "<h3 class='estado glyphicon glyphicon-exclamation-sign' title='Suscripción de administrador caducada' data-placement='bottom' style='color:#616161;font-size:14px'></h3>";
				//else
				//{
					if ($status_suscripcion2 == 1)
						$salida_estado .= "<h3 class='estado glyphicon glyphicon-exclamation-sign' title='Suscripción caducada' data-placement='bottom' style='color:#5cb85c;font-size:14px'></h3>";
					/*else
					{
						if ($online == 1)
							$salida_estado .= "<h3 class='panel-title estado' title='En línea' data-placement='bottom' style='color:#f0ad4e'>&#8226;</h3>";
						else
							$salida_estado .= "";
					}*/
				//}
			//}
		//}
	}
	return $salida_estado;
}

function nombre_logo() {
	global $conexion;
	$query_consultar = mysqli_query($conexion, "SELECT nombre_logo FROM configuracion_logo");
	$nombre_logo = mysqli_fetch_array($query_consultar);
	return ($nombre_logo["nombre_logo"]);
}

function notificaciones_pendientes() {
	global $conexion;
	if ($_SESSION['tipo_usuario'] == 1) {
		$query_notificaciones = mysqli_query($conexion, "SELECT COUNT(*) AS notificaciones_pendientes FROM entradas WHERE actividad <> 3 AND leida = 0");
		$notificaciones_pendientes = mysqli_fetch_assoc($query_notificaciones);
		return $notificaciones_pendientes["notificaciones_pendientes"];
	}
	else if ($_SESSION['tipo_usuario'] == 2) {
		$query_notificaciones = mysqli_query($conexion, "SELECT COUNT(*) AS notificaciones_pendientes FROM entradas_por_leer JOIN entradas ON entradas_por_leer.id_entrada = entradas.id WHERE entradas_por_leer.id_usuario = '".$_SESSION['id_usuario']."'");
		$notificaciones_pendientes = mysqli_fetch_assoc($query_notificaciones);
		return $notificaciones_pendientes["notificaciones_pendientes"];
	}
}

function inicio($id_usuario) {
	global $conexion;
	$query_inicio = mysqli_query($conexion, "SELECT inicio FROM registrados WHERE id_usuario = $id_usuario");
	$row_inicio = mysqli_fetch_array($query_inicio);
	if ($id_usuario == "a_byjkal")
		return 1;
	else
		return $row_inicio["inicio"];
}

function minutos() {
	$minutos = "javier";
	return $minutos;
}

function segundos() {
	$segundos = "abreu";
	return $segundos;
}

function entrada_por_leer($privilegios, $conexion, $id_entrada, $id_admin) {
	if (($privilegios > 2) && ($id_admin))
		$query = mysqli_query($conexion, "INSERT INTO entradas_por_leer (id_entrada, id_usuario) VALUES ($id_entrada, $id_admin)");
}

function caducidad_suscripcion($tipo, $tiempo, $fecha) {
	$nueva_fecha = new DateTime($fecha);
	$time =  $nueva_fecha->getTimestamp();
	if ($tipo == 1)
		$fecha_caducidad = $time + ($tiempo * 60);
	if ($tipo == 3) {
		$dias = $tiempo * 30;
		$fecha_caducidad = $time + ($dias * 24 * 60 * 60);
	}
	return $fecha_caducidad;
}

function guardar_suscripcion($conexion, $ultimo_id, $suscripcion, $tiempo_suscripcion, $dias) {
	$fecha = date('Y-m-d H:i:s');
	if ($suscripcion == 1 || $suscripcion == 3)
		$sql_guardar = "INSERT INTO suscripcion (id_usuario, tipo, tiempo, tiempo2, fecha) VALUES ($ultimo_id, trim($suscripcion), trim($tiempo_suscripcion), trim($tiempo_suscripcion), '".$fecha."')";
	if ($suscripcion == 2) {
		$dias = implode(",", $dias);
		$sql_guardar = "INSERT INTO suscripcion (id_usuario, tipo, fecha, dias) VALUES ($ultimo_id, trim($suscripcion), '".$fecha."', '".$dias."')";
	}
	$query_guardar = mysqli_query($conexion, $sql_guardar);
}

function actualizar_suscripcion($id_usuario, $conexion, $tipo, $tiempo, $dias) {
	$fecha = date('Y-m-d H:i:s');
	$dias = implode(",", $dias);
	$query = mysqli_query($conexion, "SELECT suscripcion.*, registrados.status AS status_reg, registrados.privilegios, registrados.id_administrador FROM suscripcion JOIN registrados ON suscripcion.id_usuario = registrados.id_usuario WHERE suscripcion.id_usuario = $id_usuario");
	if (mysqli_num_rows($query) > 0) {
		$fila = mysqli_fetch_array($query);
		if ($tipo == 1 || $tipo == 3) {
			if ($fila['tipo'] != $tipo || $fila['tiempo2'] != $tiempo) {
				if ($fila['tiempo2'] == 0)
					$sql_actualizar = "UPDATE suscripcion SET tipo = $tipo, tiempo = $tiempo, tiempo2 = $tiempo, fecha = '".$fecha."', dias = '' WHERE id_usuario = $id_usuario";
				else {
					if ($tiempo > $fila['tiempo2'])
						$tiempo = ($tiempo - $fila['tiempo2']) + $fila['tiempo2'];
					else
						$tiempo = $fila['tiempo2'] - ($fila['tiempo2'] - $tiempo);
					$sql_actualizar = "UPDATE suscripcion SET tipo = $tipo, tiempo = $tiempo, tiempo2 = $tiempo, dias = '' WHERE id_usuario = $id_usuario";
				}
				$query_actualizar = mysqli_query($conexion, $sql_actualizar);
				$caducidad_suscripcion = caducidad_suscripcion($tipo, $tiempo, $fecha);
				if ($caducidad_suscripcion <= time())
					entrada_suscripcion();
				else
				{
					if ($fila["status2"] != 0) {
						$query_entrada = mysqli_query($conexion, "INSERT INTO entradas (usuario_id, fecha, actividad) VALUES ($id_usuario, ".time().", 11)");
						$ultimo_id = mysqli_insert_id($conexion);
						entrada_por_leer($fila['privilegios'], $conexion, $ultimo_id, $fila['id_administrador']);
						$query_actualizar_status = mysqli_query($conexion, "UPDATE suscripcion SET status2 = 0 WHERE id_usuario = $id_usuario");
					}
					if ($fila['privilegios'] == 2)
						$habilitar_usuarios_estandar = mysqli_query($conexion, "UPDATE suscripcion LEFT JOIN registrados ON registrados.id_usuario = suscripcion.id_usuario SET suscripcion.status = 0 WHERE registrados.id_administrador = $id_usuario");
				}
			}
		}
		if ($tipo == 2) {
			if ($fila['tipo'] != $tipo || $fila['dias'] != $dias) {
				$sql_actualizar = mysqli_query($conexion, "UPDATE suscripcion SET tipo = $tipo, tiempo = 0, tiempo2 = 0, fecha = '".$fecha."', dias = '".$dias."', status2 = 0 WHERE id_usuario = $id_usuario");
				if ($fila["status2"] != 0) {
					$query_entrada = mysqli_query($conexion, "INSERT INTO entradas (usuario_id, fecha, actividad) VALUES ($id_usuario, ".time().", 11)");
					$ultimo_id = mysqli_insert_id($conexion);
					entrada_por_leer($fila['privilegios'], $conexion, $ultimo_id, $fila['id_administrador']);
				}
				if ($fila['privilegios'] == 2)
					$habilitar_usuarios_estandar = mysqli_query($conexion, "UPDATE suscripcion LEFT JOIN registrados ON registrados.id_usuario = suscripcion.id_usuario SET suscripcion.status = 0 WHERE registrados.id_administrador = $id_usuario");
			}
		}
	}
	else
		$query_actualizar = mysqli_query($conexion, "INSERT INTO suscripcion (id_usuario, tipo, tiempo, tiempo2, fecha) VALUES ($id_usuario, trim($tipo), trim($tiempo), trim($tiempo), '".$fecha."')");
}

function entrada_suscripcion () {
	global $conexion;
	$hoy_timestamp = time();
	$query = mysqli_query($conexion, "SELECT suscripcion.tipo, suscripcion.tiempo, suscripcion.fecha, suscripcion.status2, registrados.id_usuario AS id_usuario, registrados.status AS status, registrados.id_administrador AS id_administrador, registrados.privilegios AS privilegios, entradas.fecha AS fecha_entrada, entradas.actividad AS actividad_entrada FROM suscripcion JOIN registrados ON suscripcion.id_usuario = registrados.id_usuario LEFT JOIN entradas ON entradas.usuario_id = registrados.id_usuario GROUP BY registrados.id_usuario HAVING suscripcion.status2 = 0");
	if (mysqli_num_rows($query) > 0) {
		while ($filas = mysqli_fetch_array($query)) {
			if ($filas['tipo'] != 2 && $filas['privilegios'] != 1) {
				$caducidad_suscripcion = caducidad_suscripcion($filas['tipo'], $filas['tiempo'], $filas['fecha']);
				if ($caducidad_suscripcion <= $hoy_timestamp) {
					$actualizar_tiempo = mysqli_query($conexion, "UPDATE suscripcion JOIN registrados ON suscripcion.id_usuario = registrados.id_usuario SET suscripcion.tiempo2 = 0, suscripcion.status2 = 1, registrados.online = 0 WHERE suscripcion.id_usuario = '".$filas['id_usuario']."'");
					$query_entrada = mysqli_query($conexion, "INSERT INTO entradas (usuario_id, fecha, actividad) VALUES ('".$filas['id_usuario']."', '".$hoy_timestamp."', 9)");
					$ultimo_id = mysqli_insert_id($conexion);
					entrada_por_leer($filas['privilegios'], $conexion, $ultimo_id, $filas['id_administrador']);
					if ($filas['privilegios'] == 2)
						$inhabilitar_usuarios_estandar = mysqli_query($conexion, "UPDATE suscripcion LEFT JOIN registrados ON registrados.id_usuario = suscripcion.id_usuario SET suscripcion.status = 1 WHERE registrados.id_administrador = '".$filas['id_usuario']."'");
				}
			}
		}
	}
}

function getTipoUsuario($id_usuario)
{
	global $conexion;

	$query = "SELECT privilegios
		FROM registrados
		WHERE id_usuario = '$id_usuario'";

	if ( $resultado = mysqli_query($conexion, $query) )
		$fila = mysqli_fetch_row($resultado);

	return $fila[0];
}

/**
 * Funciones nuevas para el iframe - temporal
 */
function getSrcIframe($sala, $canal)
{
	global $conexion;

	$query = 'SELECT src
		FROM canal_iframe
		WHERE sala = "'.$sala.'" AND canal = "'.$canal.'"';

	if ( $resultado = mysqli_query($conexion, $query) )
		$fila = mysqli_fetch_row($resultado);

	return $fila[0];
}
function getStatusIframe($sala, $canal)
{
	global $conexion;

	$query = 'SELECT status
		FROM canal_iframe
		WHERE sala = "'.$sala.'" AND canal = "'.$canal.'"';

	if ( $resultado = mysqli_query($conexion, $query) )
		$fila = mysqli_fetch_row($resultado);

	return $fila[0];
}
######### End Funciones Iframe

function _rand_url()
{
	$rand = [];
	$obfuscate_length = 115;
	$characters = 'abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVXYZ0123456789-_.:?';
	$characters_length = strlen($characters) - 1;
	$i = 0;

	while ( $i < $obfuscate_length )
	{
		$rand[$i] = substr( $characters, rand(0, $characters_length), 1 );
		$i++;
	}

	$rand = join('', $rand);

	return $rand;
}

function _rand_rtmp()
{
	$rand = [];
	$obfuscate_length = 115;
	$characters = 'abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVXYZ0123456789|#$%&/=*+-_.:?';
	$characters_length = strlen($characters) - 1;
	$i = 0;

	while ( $i < $obfuscate_length )
	{
		$rand[$i] = substr( $characters, rand(0, $characters_length), 1 );
		$i++;
	}

	$rand = join('', $rand);

	return $rand;
}

function url_obfs( $url )
{
	if ( $url )
	{
		$url_length = strlen($url);
		$new_url = [];
		$i = 0;
		$url_half = (int) floor($url_length / 2);

		while ( $i < $url_length )
		{
			if ( $i < $url_half )
				$new_url[$i] = $url[$i];
			if ( $i == $url_half )
				$new_url[$i] = _rand_url() . $url[$i];
			else
				$new_url[$i] = $url[$i];
			$i++;
		}

		$new_url = _rand_url() . join('', $new_url) . _rand_url();

		return $new_url;
	}
	else
		return '';
}

function rtmp_obfs( $rtmp )
{
	if ( $rtmp )
	{
		$rtmp_length = strlen($rtmp);
		$new_rtmp = [];
		# $i = 0;
		$j = 0;
		$rtmp_half = (int) floor( $rtmp_length / 2 );

		while ( $j < $rtmp_length )
		{
			if ( $j < $rtmp_half )
				$new_rtmp[$j] = $rtmp[$j];
			if ( $j == $rtmp_half )
				$new_rtmp[$j] = _rand_rtmp() . $rtmp[$j];
			else
				$new_rtmp[$j] = $rtmp[$j];

			$j++;
			# $i++;
		}

		$new_rtmp = _rand_rtmp() . join('', $new_rtmp) . _rand_rtmp();

		return $new_rtmp;
	}
	else
		return '';
}

function url_obfs_des( $url )
{
	if ( $url )
	{
		$url_length = strlen($url);
		$url_original = [];
		$url_original_temp = [];
		$obfuscate_length = 115;
		$j = 0;

		for ( $i=$obfuscate_length; $i<($url_length - $obfuscate_length); $i++ )
		{
			$url_original_temp[$j] = $url[$i];
			$j++;
		}

		$url_original_temp = join('', $url_original_temp);
		$url_length = strlen($url_original_temp);
		$url_half = (int) floor( $url_length / 2 );

		if ( ($url_length % 2) == 0 )
		{
			for ( $i=0; $i<$url_length; $i++ )
			{
				if ( $i == ($url_half - 58) )
					$i = $url_half + 57;

				$url_original[$i] = $url_original_temp[$i];
			}
		}
		else
		{
			for ( $i=0; $i<$url_length; $i++ )
			{
				if ( $i == ($url_half - 57) )
					$i = $url_half + 58;

				$url_original[$i] = $url_original_temp[$i];
			}
		}

		$url_original = join('', $url_original);

		return $url_original;
	}
	else
		return '';
}

function rtmp_obfs_des( $rtmp )
{
	if ( $rtmp )
	{
		$rtmp_length = strlen($rtmp);
		$rtmp_original = [];
		$rtmp_original_temp = [];
		$obfuscate_length = 115;
		$j = 0;

		for ( $i=$obfuscate_length; $i<($rtmp_length - $obfuscate_length); $i++ )
		{
			$rtmp_original_temp[$j] = $rtmp[$i];
			$j++;
		}

		$rtmp_original_temp = join('', $rtmp_original_temp);
		$rtmp_length = strlen($rtmp_original_temp);
		$url_half = (int) floor($rtmp_length / 2);

		if ( ($rtmp_length % 2) == 0 )
		{
			for ( $i=0; $i<$rtmp_length; $i++ )
			{
				if ( $i == ($url_half - 58) )
					$i = $url_half + 57;

				$rtmp_original[$i] = $rtmp_original_temp[$i];
			}
		}
		else
		{
			for ( $i=0; $i<$rtmp_length; $i++ )
			{
				if ( $i == ($url_half - 57) )
					$i = $url_half + 58;

				$rtmp_original[$i] = $rtmp_original_temp[$i];
			}
		}

		$rtmp_original = join('', $rtmp_original);

		return $rtmp_original;
	}
	else
		return '';
}

/**
 * Conteo Login
 * Actualmente estas funciones no están funcionando,
 * ya que las preguntas de seguridad están activas.
 */
function init_conteo($id_usuario, $valor_conteo)
{
	global $conexion;
	$query_actualizar = mysqli_query($conexion, "INSERT INTO conteo_login (id_usuario, valor_conteo, time_conteo) VALUES ('".$id_usuario."', $valor_conteo, '".time()."')");
}

function verificar_conteo($id_usuario)
{
	# Verifica si no existe ya un conteo para este usuario.
	global $conexion;
	$aux = 0; # No existe un conteo
	$query_actualizar = mysqli_query($conexion, "SELECT id_conteo FROM conteo_login WHERE id_usuario = '".$id_usuario."'");
	if ( mysqli_num_rows($query_actualizar) > 0 )
		$aux = 1; # Ya existe un conteo
	return $aux;
}

function eliminar_conteo($id_usuario)
{
	global $conexion;
	$query_actualizar = mysqli_query($conexion, "DELETE FROM conteo_login WHERE id_usuario = '".$id_usuario."'");
}

function valor_conteo($id_usuario)
{
	global $conexion;
	$query_valor_conteo = mysqli_query($conexion, "SELECT valor_conteo FROM conteo_login WHERE id_usuario = '".$id_usuario."'");
	$valor_conteo = mysqli_fetch_assoc($query_valor_conteo);
	return $valor_conteo['valor_conteo'];
}

function time_conteo($id_usuario)
{
	global $conexion;
	$query_time_conteo = mysqli_query($conexion, "SELECT time_conteo FROM conteo_login WHERE id_usuario = '".$id_usuario."'");
	$time_conteo = mysqli_fetch_assoc($query_time_conteo);
	return $time_conteo['time_conteo'];
}

function enlazar_usuario_superadmin($id_superadmin, $id_usuario_creado)
{
	global $conexion;
	$sql = 'INSERT INTO usuarios_superadmin (id_superadmin, id_usuario_creado)
		VALUES ("'.$id_superadmin.'", "'.$id_usuario_creado.'")';
	$guardar = mysqli_query($conexion, $sql);
}

function eliminar_enlace_usuario_superadmin($id_usuario_creado)
{
	global $conexion;
	$sql = 'DELETE FROM usuarios_superadmin WHERE id_usuario_creado = "'.$id_usuario_creado.'"';
	$eliminar = mysqli_query($conexion, $sql);
}

?>