<?php

require_once(dirname(__FILE__).'/'.'Admin.php');
include_once 'Conexion.php';
include_once 'Paginacion.php';

class Reporte
{
	private function consultaPorDia($fecha, $paginacion)
	{
		$bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT registrados.id_usuario, registrados.nombre, registrados.clave,
         registrados.ip, registrados.privilegios, registrados.id_administrador
     		FROM registrados
     		JOIN entradas ON registrados.id_usuario = entradas.usuario_id
         WHERE (DATE_FORMAT(FROM_UNIXTIME(entradas.fecha), "%d/%m/%Y") = "'.$fecha.'")
            AND (entradas.actividad BETWEEN 1 AND 3)
         GROUP BY (registrados.id_usuario)
         ORDER BY (registrados.privilegios) ASC
         LIMIT '.$paginacion->getOffset().', '.$paginacion->getFilasPagina().'';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
	}

   private function numFilasPorDia($fecha)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT registrados.id_usuario
         FROM registrados
         JOIN entradas ON registrados.id_usuario = entradas.usuario_id
         WHERE DATE_FORMAT(FROM_UNIXTIME(entradas.fecha), "%d/%m/%Y") = "'.$fecha.'"
            AND (entradas.actividad BETWEEN 1 AND 3)
         GROUP BY (registrados.id_usuario)';

      if ($estc = $bd->ejecutar($query))
      {
         $aux = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   private function consultaPorSemana($semana, $paginacion)
   {
      $bd = new Conexion();
      $data = [];
      $i = 0;

      $query = 'SELECT registrados.id_usuario, registrados.nombre, registrados.clave,
         registrados.ip, registrados.privilegios, registrados.id_administrador
         FROM registrados
         JOIN entradas ON registrados.id_usuario = entradas.usuario_id
         WHERE (DATE_FORMAT(FROM_UNIXTIME(entradas.fecha), "%v") = "'.$semana.'")
            AND (entradas.actividad BETWEEN 1 AND 3)
         GROUP BY (registrados.id_usuario)
         ORDER BY (registrados.privilegios) ASC
         LIMIT '.$paginacion->getOffset().', '.$paginacion->getFilasPagina().'';

      if ($estc = $bd->ejecutar($query))
      {
         while ($filas = $bd->obtenerFilas($estc))
         {
            $data[$i] = $filas;
            $i++;
         }

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $data;
   }

   private function numFilasPorSemana($semana)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT registrados.id_usuario
         FROM registrados
         JOIN entradas ON registrados.id_usuario = entradas.usuario_id
         WHERE DATE_FORMAT(FROM_UNIXTIME(entradas.fecha), "%v") = "'.$semana.'"
            AND (entradas.actividad BETWEEN 1 AND 3)
         GROUP BY (registrados.id_usuario)';

      if ($estc = $bd->ejecutar($query))
      {
         $aux = $bd->obtenerCantidadFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   private function __consultaPorDiaHtml($fecha, $pag_num)
   {
      $salida_html = '';

      $paginacion = new Paginacion($this->numFilasPorDia($fecha), $pag_num);

      $salida_html .= '
         <div class="subtitulo">
            <p>Reporte por día: '.$fecha.'
            <span class="badge" style="background-color:#5bc0de">
               '.$paginacion->getTotalFilas().'</span></p>
         </div>
         <div class="table-responsive">
            <table class="table table-usuarios">
               <thead>
                  <tr>
                     <th>Usuario</th>
                     <th>Contraseña</th>
                     <th>Dirección IP</th>
                     <th>Privilegios</th>
                     <th>Responsable</th>
                  </tr>
               </thead>
               <tbody>';

      if ($paginacion->getTotalFilas())
      {
         $filas = $this->consultaPorDia($fecha, $paginacion);

         $obj_admin = new Admin();

         foreach ($filas as $reporte)
         {
            $salida_html .= '<tr>
               <td><a href="/cl/todos.php?id_usuario='.$reporte['id_usuario'].'">
                  '.$reporte['nombre'].'</a></td>
               <td>'.$reporte['clave'].'</td>
               <td>'.$reporte['ip'].'</td>
               <td>'.$obj_admin->nombrePrivilegios($reporte['privilegios']).'</td>';

               $salida_html .= '<td>'.$obj_admin->__columnaResponsable(
                  $reporte['id_usuario'], $reporte['privilegios'], $reporte['id_administrador']).'</td>';

            $salida_html .= '</tr>';
         }

               $salida_html .= '</tbody>
            </table>
         </div>';

         $salida_html .= $paginacion->__htmlReportes($fecha, 0);
      }
      else
      {
         $salida_html .= '
                  <tr><td class="vacio" colspan="5">No hay resultados.</td></tr>
               </tbody>
            </table>
         </div>';
      }

      return $salida_html;
   }

   private function __consultaPorSemanaHtml($semana, $pag_num)
   {
      $salida_html = '';

      $paginacion = new Paginacion($this->numFilasPorSemana($semana), $pag_num);

      $salida_html .= '
         <div class="subtitulo">
            <p>Reporte por semana: '.$semana.'
            <span class="badge" style="background-color:#5bc0de">
               '.$paginacion->getTotalFilas().'</span></p>
         </div>
         <div class="table-responsive">
            <table class="table table-usuarios">
               <thead>
                  <tr>
                     <th>Usuario</th>
                     <th>Contraseña</th>
                     <th>Dirección IP</th>
                     <th>Privilegios</th>
                     <th>Responsable</th>
                  </tr>
               </thead>
               <tbody>';

      if ($paginacion->getTotalFilas())
      {
         $filas = $this->consultaPorSemana($semana, $paginacion);

         $obj_admin = new Admin();

         foreach ($filas as $reporte)
         {
            $salida_html .= '<tr>
               <td><a href="/cl/todos.php?id_usuario='.$reporte['id_usuario'].'">
                  '.$reporte['nombre'].'</a></td>
               <td>'.$reporte['clave'].'</td>
               <td>'.$reporte['ip'].'</td>
               <td>'.$obj_admin->nombrePrivilegios($reporte['privilegios']).'</td>';

               $obj_admin = new Admin();
               $salida_html .= '<td>'.$obj_admin->__columnaResponsable(
                  $reporte['id_usuario'], $reporte['privilegios'], $reporte['id_administrador']).'</td>';

            $salida_html .= '</tr>';
         }

               $salida_html .= '</tbody>
            </table>
         </div>';

         $salida_html .= $paginacion->__htmlReportes(0, $semana);
      }
      else
      {
         $salida_html .= '
                  <tr><td class="vacio" colspan="5">No hay resultados.</td></tr>
               </tbody>
            </table>
         </div>';
      }

      return $salida_html;
   }

	private function __barraBotonesHtml()
	{
		$salida_html = '
         <div class="barra-botones">
            <div class="container-fluid">
               <div class="contenedor-botones">
               	<button class="btn btn-info" title="Actualizar" data-toggle="actualizar_html"
               		data-accion="actualizar_reportes" data-placement="bottom">
               		<i class="glyphicon glyphicon-refresh"></i>
                  </button>
                  <div class="btn-group">
                     <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-expanded="false"
                        title="Tipo de reporte" data-placement="bottom"><i class="glyphicon glyphicon-list-alt"></i>
                     </button>
                     <ul class="dropdown-menu reporte" role="menu">
                        <li><a href="#rep1">Por día</a></li>
                        <li><a href="#rep2">Por semana</a></li>
                     </ul>
                  </div>
               </div>
            </div>
         </div>';

      return $salida_html;
	}

	public function __html($f1_get, $sem_get, $pag_num)
	{
		$salida_html = $this->__barraBotonesHtml();

		$salida_html .= '
         <div class="row">
      		<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
      			<div class="panel panel-default form-tipo-reporte">
     					<div class="panel-body">Seleccione el tipo de reporte.</div>
   				</div>
   			</div>
         </div>';

      if ($f1_get != 0) # Muestro reporte por dia
         $salida_html .= $this->__consultaPorDiaHtml($f1_get, $pag_num);
      else if ($sem_get != 0) # Muestro reporte por semana
         $salida_html .= $this->__consultaPorSemanaHtml($sem_get, $pag_num);

		return $salida_html;
	}
}

?>