<?php

class Obfuscate
{
	# Obfusca la url.
	public function urlObfuscar($url)
	{
		if ( $url )
		{
			$url_length = strlen($url);
			$new_url = [];
			$i = 0;
			$url_half = (int) floor($url_length / 2);

			while ( $i < $url_length )
			{
				if ( $i < $url_half )
					$new_url[$i] = $url[$i];
				if ( $i == $url_half )
					$new_url[$i] = $this->randUrl() . $url[$i];
				else
					$new_url[$i] = $url[$i];
				$i++;
			}

			$new_url = $this->randUrl() . join('', $new_url) . $this->randUrl();

			return $new_url;
		}
		else
			return '';
	}

	 # Obfusca el rtmp.
	public function rtmpObfuscar($rtmp)
	{
		if ( $rtmp )
		{
			$rtmp_length = strlen($rtmp);
			$new_rtmp = [];
			#$i = 7;
			$j = 0;
			$rtmp_half = (int) floor( $rtmp_length / 2 );

			while ( $j < $rtmp_length )
			{
				if ( $j < $rtmp_half )
					$new_rtmp[$j] = $rtmp[$j];
				if ( $j == $rtmp_half )
					$new_rtmp[$j] = $this->randRtmp() . $rtmp[$j];
				else
					$new_rtmp[$j] = $rtmp[$j];

				$j++;
				#$i++;
			}

			$new_rtmp = $this->randRtmp() . join('', $new_rtmp) . $this->randRtmp();

			return $new_rtmp;
		}
		else
			return '';
	}

	# Desofusca la url.
	public function urlDesofuscar($url)
	{
		if ( $url )
		{
			$url_length = strlen($url);
			$url_original = [];
			$url_original_temp = [];
			$obfuscate_length = 115;
			$j = 0;

			for ( $i=$obfuscate_length; $i<($url_length - $obfuscate_length); $i++ )
			{
				$url_original_temp[$j] = $url[$i];
				$j++;
			}

			$url_original_temp = join('', $url_original_temp);
			$url_length = strlen($url_original_temp);
			$url_half = (int) floor( $url_length / 2 );

			if ( ($url_length % 2) == 0 )
			{
				for ( $i=0; $i<$url_length; $i++ )
				{
					if ( $i == ($url_half - 58) )
						$i = $url_half + 57;

					$url_original[$i] = $url_original_temp[$i];
				}
			}
			else
			{
				for ( $i=0; $i<$url_length; $i++ )
				{
					if ( $i == ($url_half - 57) )
						$i = $url_half + 58;

					$url_original[$i] = $url_original_temp[$i];
				}
			}

			$url_original = join('', $url_original);

			return $url_original;
		}
		else
			return '';
	}

	# Desofusca el rtmp.
	public function rtmpDesofuscar($rtmp)
	{
		if ($rtmp)
		{
			$rtmp_length = strlen($rtmp);
			$rtmp_original = [];
			$rtmp_original_temp = [];
			$obfuscate_length = 115;
			$j = 0;

			for ( $i=$obfuscate_length; $i<($rtmp_length - $obfuscate_length); $i++ )
			{
				$rtmp_original_temp[$j] = $rtmp[$i];
				$j++;
			}

			$rtmp_original_temp = join('', $rtmp_original_temp);
			$rtmp_length = strlen($rtmp_original_temp);
			$url_half = (int) floor($rtmp_length / 2);

			if ( ($rtmp_length % 2) == 0 )
			{
				for ( $i=0; $i<$rtmp_length; $i++ )
				{
					if ( $i == ($url_half - 58) )
						$i = $url_half + 57;

					$rtmp_original[$i] = $rtmp_original_temp[$i];
				}
			}
			else
			{
				for ( $i=0; $i<$rtmp_length; $i++ )
				{
					if ( $i == ($url_half - 57) )
						$i = $url_half + 58;

					$rtmp_original[$i] = $rtmp_original_temp[$i];
				}
			}

			$rtmp_original = join('', $rtmp_original);

			return $rtmp_original;
		}
		else
			return '';
	}

	# Genera caracteres aleatorios para obfuscar la url.
	private function randUrl()
	{
		$rand = [];
		$obfuscate_length = 115;
		$characters = 'abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVXYZ0123456789-_.:?';
		$characters_length = strlen($characters) - 1;
		$i = 0;

		while ( $i < $obfuscate_length )
		{
			$rand[$i] = substr( $characters, rand(0, $characters_length), 1 );
			$i++;
		}

		$rand = join('', $rand);

		return $rand;
	}

	# Genera caracteres aleatorios para obfuscar el rtmp.
	private function randRtmp()
	{
		$rand = [];
		$obfuscate_length = 115;
		$characters = 'abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVXYZ0123456789|#$%&/=*+-_.:?';
		$characters_length = strlen($characters) - 1;
		$i = 0;

		while ( $i < $obfuscate_length )
		{
			$rand[$i] = substr( $characters, rand(0, $characters_length), 1 );
			$i++;
		}

		$rand = join('', $rand);

		return $rand;
	}
}

?>