<?php

require_once(dirname(__FILE__).'/'.'Usuario.php');
include_once 'Conexion.php';

class Admin extends Usuario
{
	public function eliminarUsuarioEstandar($id_estandar)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'DELETE registrados, entradas, preguntas, suscripcion
         FROM registrados
         LEFT JOIN entradas ON registrados.id_usuario = entradas.usuario_id
         LEFT JOIN preguntas ON registrados.id_usuario = preguntas.id_usuario
         LEFT JOIN suscripcion ON registrados.id_usuario = suscripcion.id_usuario
         WHERE registrados.id_usuario = "'.$id_estandar.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   public function eliminarEnlaceUsuarioSuperadmin($id_usuario_creado)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'DELETE FROM usuarios_superadmin
         WHERE id_usuario_creado = "'.$id_usuario_creado.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   public function incrementarConteoAdministrador($id_administrador, $privilegios_usuario_nuevo)
   {
      $bd = new Conexion();
      $aux = 0;

      $campo_conteo = 'conteo'.$this->nombreColumnasTablaConteoAdministradores($privilegios_usuario_nuevo);

      $query = 'UPDATE conteo_administradores
      	SET '.$campo_conteo.' = ('.$campo_conteo.' + 1)
         WHERE id_administrador = "'.$id_administrador.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   public function decrementarConteoAdministrador($id_administrador, $valor_decremento,
   	$privilegios_usuario_nuevo)
   {
      $bd = new Conexion();
      $aux = 0;

      $campo_conteo = 'conteo'.$this->nombreColumnasTablaConteoAdministradores($privilegios_usuario_nuevo);

      $query = 'UPDATE conteo_administradores
      	SET '.$campo_conteo.' = ('.$campo_conteo.' - '.$valor_decremento.')
         WHERE (id_administrador = "'.$id_administrador.'" AND '.$campo_conteo.' > 0)';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
   }

   public function validarConteoAdministrador($id_administrador, $privilegios_usuario_nuevo)
   {
      $bd = new Conexion();
      $aux = 0;

      $campo_max = 'max'.$this->nombreColumnasTablaConteoAdministradores($privilegios_usuario_nuevo);
      $campo_conteo = 'conteo'.$this->nombreColumnasTablaConteoAdministradores($privilegios_usuario_nuevo);

      $query = 'SELECT '.$campo_max.' AS max, '.$campo_conteo.' AS conteo
      	FROM conteo_administradores
         WHERE id_administrador = "'.$id_administrador.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         if ($fila['max'] > $fila['conteo'])
            $aux = 1;

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

    public function validarUsuariosPermitidosAdministrador($id_administrador, $privilegios_usuario_nuevo)
   {
      $permitidos = $this->consultaUsuariosPermitidos($id_administrador);
      $aux = false;
      $i = 0;

      while ($i < count($permitidos) && $aux == false)
      {
         if ($privilegios_usuario_nuevo == $permitidos[$i])
            $aux = true;
         $i++;
      }

      return $aux;
   }

	public function restablecerPreguntas($id_usuario)
	{
		$bd = new Conexion();
		$aux = 0;
		$hoy = time();
		$obj_notificacion = new Notificacion();

		$this->eliminarPreguntas($id_usuario);
		$this->modificarInicio($id_usuario, 2);
		$obj_notificacion->guardar($id_usuario, $hoy, 7);
		$ultimo_id = $bd->ultimoId();

		if ($fila = $this->obtenerPrivilegiosIdAdministradorUsuario($ultimo_id))
			$obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);

		$bd->cerrar();

		return $aux;
	}

	public function restablecerPreguntasArray()
	{
		$bd = new Conexion();
		$aux = 0;
		$hoy = time();
		$obj_notificacion = new Notificacion();

		if (!empty($_POST['seleccion']))
		{
			foreach ($_POST['seleccion'] as $id_usuario)
			{
				$this->eliminarPreguntas($id_usuario);
				$this->modificarInicio($id_usuario, 2);
				$obj_notificacion->guardar($id_usuario, $hoy, 7);
				$ultimo_id = $bd->ultimoId();

				if ($fila = $this->obtenerPrivilegiosIdAdministradorUsuario($ultimo_id))
					$obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);
			}

			$aux = 1;
		}

		if (!empty($_POST['seleccion2']))
		{
			foreach ($_POST['seleccion2'] as $id_usuario)
			{
				$this->eliminarPreguntas($id_usuario);
				$this->modificarInicio($id_usuario, 2);
				$obj_notificacion->guardar($id_usuario, $hoy, 7);
				$ultimo_id = $bd->ultimoId();

				if ($fila = $this->obtenerPrivilegiosIdAdministradorUsuario($ultimo_id))
					$obj_notificacion->guardarPorLeer($fila['privilegios'], $ultimo_id, $fila['id_administrador']);
			}

			$aux = 1;
		}

		$bd->cerrar();

		return $aux;
	}

	public function activarUsuariosArray()
	{
		$bd = new Conexion();
      $aux = 0;
      $obj_pago = new Pago();

      if (!empty($_POST['seleccion']))
      {
         foreach ($_POST['seleccion'] as $id_usuario)
         {
            $privilegios_usuario = $this->obtenerPrivilegiosUsuario($id_usuario);

            if (($privilegios_usuario != 1) && ($privilegios_usuario != $_SESSION['tipo_usuario']))
            {
            	$this->modificarStatus($id_usuario, 0);
               $obj_pago->eliminar($id_usuario);

               if ($privilegios_usuario == 2)
               	$this->modificarStatus2UsuarioDeAdministrador($id_usuario, 0);
            }
         }

         $aux = 1;
      }

      $bd->cerrar();

      return $aux;
	}

	private function modificarStatus2UsuarioDeAdministrador($id_administrador, $valor_status2)
	{
		$bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE registrados SET status2 = "'.$valor_status2.'"
         WHERE id_administrador = "'.$id_administrador.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
	}

	public function obtenerNombreUsuario($id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT nombre FROM registrados
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['nombre'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

	public function obtenerPrivilegiosUsuario($id_usuario)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT privilegios FROM registrados
         WHERE id_usuario = "'.$id_usuario.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = $fila['privilegios'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

	public function obtenerPrivilegiosIdAdministradorUsuario($id_usuario)
	{
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT privilegios, id_administrador
      	FROM registrados WHERE id_usuario = "'.$id_usuario.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
	}

	private function eliminarPreguntas($id_usuario)
	{
		$bd = new Conexion();
      $aux = 0;

      $query = 'DELETE FROM preguntas
      	WHERE id_usuario = "'.$id_usuario.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
	}

	/**
	 * [Modifica el valor de status en 1 y online en 0 de cualquier usuario.]
	 */
	public function suspenderUsuario($id_usuario)
	{
		$bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE registrados SET status = 1, online = 0
      	WHERE id_usuario = "'.$id_usuario.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
	}

	private function modificarInicio($id_usuario, $valor_inicio)
	{
		$bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE registrados SET inicio = "'.$valor_inicio.'"
      	WHERE id_usuario = "'.$id_usuario.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
	}

	public function modificarStatus($id_usuario, $valor_status)
	{
		$bd = new Conexion();
      $aux = 0;

      $query = 'UPDATE registrados SET status = "'.$valor_status.'"
      	WHERE id_usuario = "'.$id_usuario.'"';

      if ($bd->ejecutar($query))
         $aux = 1;

      $bd->cerrar();

      return $aux;
	}

	public function consultaUsuariosPermitidos($id_administrador)
   {
      $bd = new Conexion();
      $aux = 0;

      $query = 'SELECT usuarios_permitidos FROM conteo_administradores
         WHERE id_administrador = "'.$id_administrador.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $aux = explode(',', $fila['usuarios_permitidos']);

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      return $aux;
   }

   /**
    * [Obtiene el id y nombre del responsable (SuperAdministrador) de un usuario.]
    */
   public function obtenerNombreIdEnlaceSuperadmin($id_usuario_creado)
   {
      $bd = new Conexion();
      $id = '';
      $nombre= '';

      $query = 'SELECT registrados.id_usuario, registrados.nombre
         FROM registrados
         JOIN usuarios_superadmin
            ON registrados.id_usuario = usuarios_superadmin.id_superadmin
         WHERE usuarios_superadmin.id_usuario_creado = "'.$id_usuario_creado.'"';

      if ($estc = $bd->ejecutar($query))
      {
         $fila = $bd->obtenerFilas($estc);
         $id = $fila['id_usuario'];
         $nombre = $fila['nombre'];

         $bd->liberarResultados($estc);
      }

      $bd->cerrar();

      $salida_json = json_encode(['id' => $id, 'nombre' => $nombre]);

      return $salida_json;
   }

   public function __columnaResponsable($id_administrado, $privilegios_administrado, $id_administrador)
   {
      $valor_celda = '';

      if ($privilegios_administrado == 2)
      {
         $responsable = json_decode($this->obtenerNombreIdEnlaceSuperadmin($id_administrado), true);
         $valor_celda = '<a href="todos.php?id_usuario='.$responsable['id'].'">'.$responsable['nombre'].'</a>';
      }
      else if ($privilegios_administrado == 1)
         $valor_celda = '';
      else
      {
         if (!$id_administrador)
            $valor_celda = 'Sin responsable';
         else
         {
            $valor_celda = '<a href="todos.php?id_usuario='.$id_administrador.'">
               '.$this->obtenerNombreUsuario($id_administrador).'</a>';
         }
      }

      return $valor_celda;
   }

	public function nombreStatus($status)
	{
		$nombres_status = [
			0 => "Activo",
			1 => "Suspendido",
			2 => "Activo" ];

		return $nombres_status[$status];
	}

	public function nombrePrivilegios($numero_privilegios)
	{
		$nombres_privilegios = [
			"" => "0",
			"1" => "Super administrador",
			"2" => "Administrador",
			"3" => "Nacionales",
			"4" => "Americanas",
			"5" => "Americanas-Nacionales" ];

		return $nombres_privilegios[$numero_privilegios];
	}

	public function nombrePrivilegiosPlural($numero_privilegios)
	{
		$nombres_privilegios = [
			"" => "0",
			"1" => "super administradores",
			"2" => "administradores",
			"3" => "nacionales",
			"4" => "americanas",
			"5" => "americanas-nacionales" ];

		return $nombres_privilegios[$numero_privilegios];
	}

	public function nombreColumnasTablaConteoAdministradores($privilegios)
	{
		$nombre_columnas = [ 3 => '_nacionales', 4 => '_americanas', 5 => '_an' ];

		return $nombre_columnas[$privilegios];
	}

	public function __htmlCheck($status, $id_usuario)
	{
		if ($status == '1')
		{
			$checked = 'checked';
			$name = 'my-checkbox-todos1';
		}
		else
		{
			$checked = '';
			$name = 'my-checkbox-todos2';
		}

		return '<input type="checkbox" name="'.$name.'" class="bootstrap-switch-mini" value="'.$id_usuario.'" checked>';
	}

	public function colorVista($vista)
	{
		$color_badge = [
			'act' => '#f0ad4e',
			'desc' => '',
			'susp' => '#434343',
			'todos' => '#5bc0de',
			'mis_usuarios' => '#5bc0de' ];

		return $color_badge[$vista];
	}

	public function statusUsuarioIcono($online, $status, $status2,
		$status_suscripcion, $status_suscripcion2)
	{
		$salida_estado = '';

		if ($online == 1)
		{
			$salida_estado = "<h3 class='estado glyphicon glyphicon-asterisk' title='En línea' data-placement='bottom' style='color:#f0ad4e;font-size:12px'></h3>";
		}
		else
		{
			if ($status == 1)
			{
				$salida_estado = "<h3 class='estado glyphicon glyphicon-minus' title='Suspendido' data-placement='bottom' style='color:#434343;font-size:14px'></h3>";
			}
			if ($status2 == 1)
			{
				$salida_estado .= "<h3 class='estado glyphicon glyphicon-minus-sign' title='Responsable suspendido' data-placement='bottom' style='color:#616161;font-size:14px'></h3>";
			}
			if ($status_suscripcion == 1)
			{
				$salida_estado .= "<h3 class='estado glyphicon glyphicon-exclamation-sign' title='Suscripción de administrador caducada' data-placement='bottom' style='color:#616161;font-size:14px'></h3>";
			}
			if ($status_suscripcion2 == 1)
			{
				$salida_estado .= "<h3 class='estado glyphicon glyphicon-exclamation-sign' title='Suscripción caducada' data-placement='bottom' style='color:#5cb85c;font-size:14px'></h3>";
			}
		}

		return $salida_estado;
	}

	/**
	 * [Muestra los datos principales del usuario en cualquier ventana ver_detalles.]
	 */
	public function __panelVerDetallesHtml($fila, $pagina, $privilegios_session)
	{
		$salida_html = '
         <div class="panel panel-info" style="">
            <div class="panel-heading">
               <h3 class="panel-title" style="display:inline">
						<i class="glyphicon glyphicon-user"></i> '.$fila['nombre'].
               	  	$this->statusUsuarioIcono($fila['online'], $fila['status'], $fila['status2'],
                     	$fila['suscripcion_status'], $fila['suscripcion_status2']).'
               </h3>
				</div>
				<div class="panel-body" style="padding:0">
            	<div class="table-responsive">
               	<table class="table table-condensed">
                  	<tbody>
                     	<tr>
                        	<th width="125" align="left">Dirección IP:</th>
                           <td align="right">'.$fila['ip'].'</td>
								</tr>
                        <tr>
                        	<th width="100" align="left">Privilegios:</th>
                           <td align="right">'.$this->nombrePrivilegios($fila['privilegios']).'</td>
								</tr>';
								if ($fila['privilegios'] >= 2 && $privilegios_session == 1)
								{
									$salida_html .= '
										<tr>
											<th width="150">Responsable:</th>
											<td align="right">';
                                 if ($fila['privilegios'] == 2)
                                 {
                                    $responsable_json = json_decode($this->obtenerNombreIdEnlaceSuperadmin($fila['id_usuario']), true);

                                    $salida_html .= '<a href="/cl/todos.php?id_usuario='.$responsable_json['id'].'">
                                       '.$responsable_json['nombre'].'</a>';
                                 }
                                 else if ($fila['privilegios'] > 2)
                                 {
                                    if ($fila['id_administrador'])
                                    {
                                       $salida_html .= '<a href="/cl/todos.php?id_usuario='.$fila['id_administrador'].'">
      										     '.$this->obtenerNombreUsuario($fila['id_administrador']).'</a>';
                                    }
                                    else
                                       $salida_html .= 'Sin responsable';
                                 }
											$salida_html .= '</td>
										</tr>';
								}
                        $salida_html .= '<tr>
                        	<th>Status:</th>
                           <td align="right">'.$this->nombreStatus($fila['status']).'</td>
								</tr>
                        <tr>
                        	<td style="border-bottom:none">
                           	'.$this->__htmlCheck($fila['status'], $fila['id_usuario']).'
									</td>
                           <td align="right" height="35" style="border-bottom:none">';
                           	if ($fila['privilegios'] == 2 && $pagina == 'mis_usuarios')
										{
                                 $salida_html .= '
                                    <a href="?administrador='.$fila['id_usuario'].'">
                                    	<i class="glyphicon glyphicon-user" title="Ver usuarios administrados"></i>
                                    </a> ';
                              }
                           	$salida_html .= '<a href="'.$fila['id_usuario'].'" data-accion="restablecer_preguntas"
                           		data-toggle="confirmar"><i class="glyphicon glyphicon-repeat"
                           		title="Restablecer pregunta de seguridad"></i>
                            	</a>
										<a href="'.$fila['id_usuario'].'" data-accion="modificar_ver" data-toggle="actualizar_usuario"
											dbd_clave="'.$fila['clave'].'"
											dbd_nombre="'.$fila['nombre'].'"
											dbd_priv="'.$fila['privilegios'].'"';
                                 if ($privilegios_session == 1 && $fila['privilegios'] == 2)
                                 {
                                 	$salida_html .= '
                                       dbd_usuarios_permitidos="'.$fila['usuarios_permitidos'].'"
                                       dbd_max_nacionales="'.$fila['max_nacionales'].'"
                                       dbd_max_americanas="'.$fila['max_americanas'].'"
                                       dbd_max_an="'.$fila['max_an'].'"';
                                 }
                                 $salida_html .= 'dbd_susc_tipo="'.$fila['suscripcion_tipo'].'"
                                 dbd_susc_tiempo2="'.$fila['suscripcion_tiempo2'].'"
                                 dbd_susc_dias="'.$fila['suscripcion_dias'].'"
                                 dbd_id_administrador="'.$fila['id_administrador'].'" >
                                 <i class="glyphicon glyphicon-edit" title="Modificar"></i>
										</a>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>';

		return $salida_html;
	}

	/**
	 * [El parámetro aux sirve para verificar si se encontró o no el registro.]
	 */
	public function __barraBotonesVerDetallesHtml($pagina, $id_usuaro_get, $aux)
	{
		$salida_html = '
			<div class="barra-botones">
				<div class="container-fluid">
					<div class="contenedor-botones">
						<button class="btn btn-info" title="Volver" data-placement="bottom" onClick="history.go(-1)">
							<i class="glyphicon glyphicon-arrow-left"></i>
						</button>';
						if ($aux)
						{
							$salida_html .= ' <button type="button" class="btn btn-info" href="'.$id_usuaro_get.'" data-accion="eliminar_usuario"
								data-toggle="confirmar"	title="Eliminar" data-placement="bottom"><i class="glyphicon glyphicon-trash"></i>
							</button>';
						}
						$salida_html .= '<div class="btn-group2">
							<button type="button" class="btn btn-info" data-accion="suspender_array" data-toggle="confirmar"
	                     title="Suspender" data-placement="bottom"><i class="glyphicon glyphicon-minus"></i>
	                  </button>
	                  <button type="button" class="btn btn-info" data-accion="reanudar_array" data-toggle="confirmar"
	                     title="Activar" data-placement="bottom"><i class="glyphicon glyphicon-ok"></i>
	                  </button>
	               </div>
					</div>
	            <div class="buscar">
	               <form id="form-buscar">
	                  <input type="text" id="campo_busqueda" placeholder="Buscar usuario">
	                  <a href="#" class="abrir-buscar">
	            	      <i title="Buscar" data-placement="bottom" class="glyphicon glyphicon-search"></i>
	                  </a>
	               </form>
	            </div>
	         </div>
      	</div>
      ';

		return $salida_html;
	}

	public function __nombreSubtituloHtml($pagina, $total_filas, $filtro_privilegios)
	{
		switch ($pagina)
		{
			case 'act':
				$titulo = 'Usuarios en línea';
				break;
			case 'desc':
				$titulo = 'Usuarios desconectados';
				break;
			case 'susp':
				$titulo = 'Usuarios suspendidos';
			case 'todos':
				$titulo = 'Todos los usuarios';
				break;
			case 'mis_usuarios':
				$titulo = 'Mis usuarios';
				break;
		}

		$salida_html = '
         <div class="subtitulo">
            <p>
            	<a href="#" title="Seleccionar todos" data-placement="bottom" class="marcar-todos"
         	   	data-accion="unchecked"><i class="glyphicon glyphicon-unchecked"></i> ';
               $titulo = ($filtro_privilegios != 0) ? $titulo.': '.$this->nombrePrivilegiosPlural($filtro_privilegios)
                  : $titulo.' ';
					$salida_html .= $titulo.
						' </a><span class="badge" style="background-color:#5bc0de">'.$total_filas.'</span>
				</p>
			</div>';

      return $salida_html;
	}
}

?>