// Sirve para llevar el conteo de los checkbox seleccionados.
var contador_seleccionados = 0;

$(document).ready(function() {

	function initElementos() {
		$("[name*='my-checkbox']").bootstrapSwitch(
			{'size': 'small', 'onColor': 'default', 'offColor': 'primary'});
		$("button, a, i, .estado").tooltip();
	} initElementos();

	// Cerrar modal.
	function cerrarModal() {
		$('.modal').modal('hide');
	}

	// Bloquear form y contenido al hacer submit.
	function bloquear() {
		$('.modal input, .modal button, .modal textarea, .modal a,' +
			'.modal select').attr('disabled', 'disabled');
	}

	// Desbloquear form y contenido.
	function desbloquear() {
		$('.modal input, .modal button, .modal textarea, .modal a,' +
			'.modal select').removeAttr('disabled');
	}

	// Seleccionar todos los check.
	$(document).on('click', '.marcar-todos', function(event) {
		event.preventDefault();
		var accion_marcar = $(this).attr('data-accion');
		if (accion_marcar == 'unchecked')
		{
			$(this).attr('data-accion', 'onchecked');
			$(this).children('i').attr('class', 'glyphicon glyphicon-check');
			$('input[name="my-checkbox"]').bootstrapSwitch('state', false);
		}
		if (accion_marcar == 'onchecked')
		{
			$(this).attr('data-accion', 'unchecked');
			$(this).children('i').attr('class', 'glyphicon glyphicon-unchecked');
			$('input[name="my-checkbox"]').bootstrapSwitch('state', true);
		}
	});

	// Acción que se genera al cambiar el estado de un check.
	$(function () {
		$('div.container-fluid #contenido').on('switchChange.bootstrapSwitch',
			'input[name="my-checkbox"]', function(event, state) {				
				if ($(this).is(':checked') == true)
				{
					$(this).parent().parent().parent().parent().removeAttr('class');
					contador_seleccionados -= 1;
				}
				else
				{
					$(this).parent().parent().parent().parent().addClass('check-sel');
					contador_seleccionados += 1;
				}
				(contador_seleccionados == 0)
					? $('.barra-botones .btn-group2').hide() : $('.barra-botones .btn-group2').show();
		});
	});

	// Nuevo canal remoto.
	$(document).on('click', '#contenido [data-toggle="crear_remoto"]', function () {
		var modal = $('#modal_canal_remoto');
		var form_load = '../forms/gestion_remote.html';
		var obj_remote = new Remote();
		modal.find('.modal-content').load(form_load, function() {
			modal.find('#form-canal-remoto').submit(function (event) {
				event.preventDefault();
				if (obj_remote.validar() == true)
					obj_remote.guardar();
			});
		});
		modal.modal('show');
	});

	// Modificar canal remoto.
	$(document).on('click', '#contenido [data-toggle="modificar_remote"]', function(event) {
		event.preventDefault();
		var modal = $('#modal_canal_remoto');
		var form_load = '../forms/gestion_remote.html';
		var id_canal = $(this).attr('href');
		var nombre = $(this).attr('dbd_nombre');
		var url = $(this).attr('dbd_url');
		var rtmp = $(this).attr('dbd_rtmp');
		var activo = ($(this).attr('dbd_activo') == 0) ? false : true;
		var iframe_activo = ($(this).attr('dbd_iframe_status') == 0) ? false : true;
		var url_iframe = $(this).attr('dbd_iframe_url');
		var obj_remote = new Remote();
		modal.find('.modal-content').load(form_load, function() {
			modal.find('.modal-title').text('Modificar canal remoto');
			modal.find('#nombre').val(nombre);
			modal.find('#url').val(url);
			modal.find('#rtmp').val(rtmp);
			modal.find('#activo').prop('checked',activo);
			modal.find('#check_iframe').prop('checked',iframe_activo);
			modal.find('#url_iframe').val(url_iframe);
			modal.find('#form-canal-remoto').submit(function (event) {
				event.preventDefault();
				if (obj_remote.validar() == true)
					obj_remote.modificar(id_canal);
			});
		});
		modal.modal('show');
	});

	// Eliminar canal remoto.
	$(document).on('click', '#contenido [data-toggle="confirmar_eliminar"]', function(event) {
		event.preventDefault();
		var modal = $('#modal_confirmar');
		var id_canal = $(this).attr('href');
		var obj_remote = new Remote();
		modal.find('.modal-content').load('../forms/confirmar.html', function() {
			modal.find('.modal-title').html('Eliminar canal remoto');
			modal.find('.modal-body').empty().append(
				'<p><span class="glyphicon glyphicon-warning-sign"></span> ' +
				'Este canal será eliminado permanentemente del sistema. ¿Desea continuar?</p>' );
			modal.find('#form-confirmar').submit(function (event) {
				event.preventDefault();
				obj_remote.eliminar(id_canal);
			});
		});
		modal.modal('show');
	});

	// Eliminar varios canales.
	$(document).on('click', '#contenido [data-toggle="confirmar_eliminar_array"]', function(event) {
		event.preventDefault();
		var modal = $('#modal_confirmar');
		var obj_remote = new Remote();
		modal.find('.modal-content').load('../forms/confirmar.html', function() {
			modal.find('.modal-title').html('Eliminar canal remoto');
			modal.find('.modal-body').empty().append(
				'<p><span class="glyphicon glyphicon-warning-sign"></span> ' +
				'El canal remoto seleccionado será eliminado permanentemente ' +
				'del sistema. ¿Desea continuar?</p>' );
			modal.find('#form-confirmar').submit(function (event) {
				event.preventDefault();
				obj_remote.eliminar_array();
			});
		});
		modal.modal('show');
	});

	// Activar canales.
	$(document).on('click', '#contenido [data-toggle="confirmar_activar"]', function(event) {
		event.preventDefault();
		var modal = $('#modal_confirmar');
		var obj_remote = new Remote();
		modal.find('.modal-content').load('../forms/confirmar.html', function() {
			modal.find('.modal-title').html('Activar canal remoto');
			modal.find('.modal-body').empty().append(
				'<p><span class="glyphicon glyphicon-warning-sign"></span> ' +
				'El canal remoto cambiará a modo activo. ¿Desea continuar?</p>' );
			modal.find('#form-confirmar').submit(function (event) {
				event.preventDefault();
				obj_remote.modificarStatus(1);
			});
		});
		modal.modal('show');
	});

	// Inactivar canales.
	$(document).on('click', '#contenido [data-toggle="confirmar_inactivar"]', function(event) {
		event.preventDefault();
		var modal = $('#modal_confirmar');
		var obj_remote = new Remote();
		modal.find('.modal-content').load('../forms/confirmar.html', function() {
			modal.find('.modal-title').html('Inactivar canal remoto');
			modal.find('.modal-body').empty().append(
				'<p><span class="glyphicon glyphicon-warning-sign"></span> ' +
				'El canal remoto cambiará a modo inactivo. ¿Desea continuar?</p>' );
			modal.find('#form-confirmar').submit(function (event) {
				event.preventDefault();
				obj_remote.modificarStatus(0);
			});
		});
		modal.modal('show');
	});

	// Gestión del menú de canales.
	$(document).on('click', '[data-toggle="menu_canales"]', function(event) {
		event.preventDefault();
		var modal = $('#modal_menu_canales');
		var obj_menu_canal = new MenuCanal();
		modal.find('.modal-content').load('../forms/gestion_menu_canales.html', function() {
			modal.find('#agregar_canal_menu').click(function () {
				obj_menu_canal.modificarStatusMenu(1);
				cargar_registros(); // Función interna de 'gestion_menu_canales.html'.
			});
			modal.find('#quitar_canal_menu').click(function () {
				obj_menu_canal.modificarStatusMenu(0);
				cargar_registros(); // Función interna de 'gestion_menu_canales.html'.
			});
		});
		modal.modal('show');
	});

	// Buscar un canal.
	$(document).on('submit', '#form-buscar', function(event) {
		event.preventDefault();
		if (!($('#campo_busqueda').val() == null || $('#campo_busqueda').val().length == 0 ||
			/^\s*$/.test($('#campo_busqueda').val())))
		{
			location.assign('?buscar='+$('#campo_busqueda').val());
		}
	});

	// Estructura de la clase Remote.
	var Remote = function()
	{
		var __this = this;

		this.guardar = function() {
			var accion = 'guardar_remote';
			var nombre = $('#nombre').val();
			var url = $('#url').val();
			var rtmp = $('#rtmp').val();
			var activo = ($("#activo").is(':checked')) ? 1 : 0;
			var iframe_activo = ($("#check_iframe").is(':checked')) ? 1 : 0;
			var url_iframe = $('#url_iframe').val();
			var nro_pag_get = $('#pag_num_hidden').val();
			var busqueda_get = $('#busqueda_hidden').val();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: accion,
					nombre: nombre,
					url: url,
					rtmp: rtmp,
					activo: activo,
					iframe_activo: iframe_activo,
					url_iframe: url_iframe,
					nro_pag_get: nro_pag_get,
					busqueda_get: busqueda_get
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					if (data.datos == 1)
					{
						$('#contenido').html(data.table);
						initElementos();
						cerrarModal();
						contador_seleccionados = 0;
					}
					else if (data.datos == 1062)
					{
						$('#nombre').addClass('requerido');
						$('#nombre').next('.error').html('Ya existe un canal remoto con este nombre');
					}
					desbloquear();
				},
				error: function() {
					alert(error_general);
				}
			});
		}

		this.modificar = function(id_canal) {
			var accion = 'modificar_remote';
			var nombre = $('#nombre').val();
			var url = $('#url').val();
			var rtmp = $('#rtmp').val();
			var activo = ($("#activo").is(':checked')) ? 1 : 0;
			var iframe_activo = ($("#check_iframe").is(':checked')) ? 1 : 0;
			var url_iframe = $('#url_iframe').val();
			var nro_pag_get = $('#pag_num_hidden').val();
			var busqueda_get = $('#busqueda_hidden').val();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: accion,
					id_canal: id_canal,
					nombre: nombre,
					url: url,
					rtmp: rtmp,
					activo: activo,
					iframe_activo: iframe_activo,
					url_iframe: url_iframe,
					nro_pag_get: nro_pag_get,
					busqueda_get: busqueda_get
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					if (data.datos == 1)
					{
						$('#contenido').html(data.table);
						initElementos();
						cerrarModal();
						contador_seleccionados = 0;
					}
					else if (data.datos == 1062)
					{
						$('#nombre').addClass('requerido');
						$('#nombre').next('.error').html('Ya existe un canal remoto con este nombre');
					}
					desbloquear();
				},
				error: function() {
					alert(error_general);
				}
			});
		}

		this.eliminar = function(id_canal) {
			var accion = 'eliminar_remote';
			var nro_pag_get = $('#pag_num_hidden').val();
			var busqueda_get = $('#busqueda_hidden').val();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: accion,
					id_canal: id_canal,
					nro_pag_get: nro_pag_get,
					busqueda_get: busqueda_get
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					$('#contenido').html(data.table);
					initElementos();
					cerrarModal();
					desbloquear();
					contador_seleccionados = 0;
				},
				error: function() {
					alert(error_general);
				}
			});
		}

		this.eliminar_array = function() {
			var accion = 'eliminar_remote_array';
			var nro_pag_get = $('#pag_num_hidden').val();
			var busqueda_get = $('#busqueda_hidden').val();
			var seleccionados = this.seleccionados();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: accion,
					nro_pag_get: nro_pag_get,
					busqueda_get: busqueda_get,
					seleccionados: seleccionados
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					$('#contenido').html(data.table);
					initElementos();
					cerrarModal();
					desbloquear();
					contador_seleccionados = 0;
				},
				error: function() {
					alert(error_general);
				}
			});
		}

		this.modificarStatus = function(status) {
			var accion = 'modificar_status_remote';
			var nro_pag_get = $('#pag_num_hidden').val();
			var busqueda_get = $('#busqueda_hidden').val();
			var seleccionados = this.seleccionados();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: accion,
					nro_pag_get: nro_pag_get,
					busqueda_get: busqueda_get,
					seleccionados: seleccionados,
					status: status
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					$('#contenido').html(data.table);
					initElementos();
					cerrarModal();
					desbloquear();
					contador_seleccionados = 0;
				},
				error: function() {
					alert(error_general);
				}
			});
		}

		this.validar = function() {
			var aux = true;

			$('[data-toggle="requerido"]').each(function() {
				if ( $('#url').val() == null || $('#url').val().length == 0
					|| /^\s+$/.test($('#url').val()) )
				{
					aux = false;
					$('#url').addClass('requerido');
					$('#url').next('.error').html('Falta url');
				}
				if ( $('#rtmp').val() == null || $('#rtmp').val().length == 0
					|| /^\s+$/.test($('#rtmp').val()) )
				{
					aux = false;
					$('#rtmp').addClass('requerido');
					$('#rtmp').next('.error').html('Falta rtmp');
				}
				if ( $('#nombre').val() == null || $('#nombre').val().length == 0
					|| /^\s+$/.test($('#nombre').val()) )
				{
					aux = false;
					$('#nombre').addClass('requerido');
					$('#nombre').next('.error').html('Falta nombre');
				}
				if ($('#check_iframe').prop('checked') == true)
				{
					if ( $('#url_iframe').val() == null || $('#url_iframe').val().length == 0
						|| /^\s+$/.test($('#url_iframe').val()) )
					{
						aux = false;
						$('#url_iframe').addClass('requerido');
						$('#url_iframe').next('.error').html('Falta url del iframe');
					}
				}
			});

			return aux;
		}

		// Retorna un array con el id de cada canal seleccionado.
		this.seleccionados = function() {
			var seleccion = [];

			$('input[name="my-checkbox"]').each(function () {
	         if ($(this).is(':checked') == false)
	         {
	            seleccion.push(
	            	$(this).parent().parent().parent().parent().children('td:eq(1)').text());
	         }
	      });

			return (seleccion.length) ? seleccion : '';
		}
	} // Fin clase Remote.

	// Estructura de la clase MenuCanal.
	var MenuCanal = function()
	{
		var __this = this;

		this.modificarStatusMenu = function(status) {
			var accion = 'modificar_status_canal_menu_remoto';
			var seleccionados = this.seleccionados();

			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: accion,
					seleccionados: seleccionados,
					status: status
				},
				beforeSend: function() {
					bloquear();
				},
				success: function() {
					desbloquear();
				},
				error: function() {
					alert(error_general);
				}
			});
		}

		// Retorna un array con el id de cada canal seleccionado.
		this.seleccionados = function() {
			var seleccion = [];

			$('input[name="check_canal_menu"]').each(function () {
	         if ($(this).prop('checked') == true)
	            seleccion.push($(this).val());
	      });

			return (seleccion.length) ? seleccion : '';
		}
	} // Fin clase MenuCanal.

});