<?php 

function randUrl()
{
	$rand = [];
	$obfuscate_length = 115;
	$characters = 'abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVXYZ0123456789-_.:?';
	$characters_length = strlen($characters) - 1;
	$i = 0;

	while ( $i < $obfuscate_length )
	{
		$rand[$i] = substr( $characters, rand(0, $characters_length), 1 );
		$i++;
	}

	$rand = join('', $rand);

	return $rand;
}

function randRtmp()
{
	$rand = [];
	$obfuscate_length = 115;
	$characters = 'abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVXYZ0123456789|#$%&/=*+-_.:?';
	$characters_length = strlen($characters) - 1;
	$i = 0;

	while ( $i < $obfuscate_length )
	{
		$rand[$i] = substr( $characters, rand(0, $characters_length), 1 );
		$i++;
	}

	$rand = join('', $rand);

	return $rand;
}

function urlObfuscar($url)
{
	if ( $url )
	{
		$url_length = strlen($url);
		$new_url = [];
		$i = 0;
		$url_half = (int) floor($url_length / 2);

		while ( $i < $url_length )
		{
			if ( $i < $url_half )
				$new_url[$i] = $url[$i];
			if ( $i == $url_half )
				$new_url[$i] = randUrl() . $url[$i];
			else
				$new_url[$i] = $url[$i];
			$i++;
		}

		$new_url = randUrl() . join('', $new_url) . randUrl();

		return $new_url;
	}
	else
		return '';
}

function rtmpObfuscar($rtmp)
{
	if ( $rtmp )
	{
		$rtmp_length = strlen($rtmp) - 7;
		$new_rtmp = [];
		$i = 7;
		$j = 0;
		$rtmp_half = (int) floor( $rtmp_length / 2 );

		while ( $j < $rtmp_length )
		{
			if ( $j < $rtmp_half )
				$new_rtmp[$j] = $rtmp[$i];
			if ( $j == $rtmp_half )
				$new_rtmp[$j] = randRtmp() . $rtmp[$i];
			else
				$new_rtmp[$j] = $rtmp[$i];

			$j++;
			$i++;
		}

		$new_rtmp = 'rtmp://' . randRtmp() . join('', $new_rtmp) . randRtmp();

		return $new_rtmp;
	}
	else
		return '';
}

?>

<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta https-equiv="X-UA-Compatible" content="IE=edge">
	<title></title>
</head>
<body>
	<form method="post">
		<label for="url">URL:</label>
		<input type="text" name="url">
		<br>
		<label for="rtmp">RTMP:</label>
		<input type="text" name="rtmp">
		<br>
		<input type="submit" name="enviar" value="Obfuscar">
	</form>
	<br>
	<?php if (isset($_POST['url']) && $_POST['url'] != null) { ?>
		<p>url obfuscada:</p>
		<textarea rows="6" cols="100"><?php echo urlObfuscar($_POST['url']) ?></textarea>
	<?php } ?>
	<br>
	<?php if (isset($_POST['rtmp']) && $_POST['rtmp'] != null) { ?>
		<p>rtmp obfuscada:</p>
		<textarea rows="6" cols="100"><?php echo rtmpObfuscar($_POST['rtmp']) ?></textarea>
	<?php } ?>
</body>
</html>