var url_controladores = '/sv/controladores/controlador.php';
var url_controlador_logout = '/sv/controladores/logout.php';
var error_general = 'Ha ocurrido un error inesperado, por favor intente mas tarde.';

$(document).ready(function () {

	// Cierra la venta modal.
	function cerrar_modal() {
		$('.modal').modal('hide');
	}

	// Deshabilita todos los controles del modal.
	function bloquear() {
		$('.modal input, .modal button, .modal textarea,' +
			'.modal a, .modal select').attr('disabled', 'disabled');
	}

	// Habilita todos los controles del modal.
	function desbloquear() {
		$('.modal input, .modal button, .modal textarea, ' +
			'.modal a, .modal select').removeAttr('disabled');
	}

	// Cerrar sesión PHP.
	$('a.logout').on('click', function (event) {
      event.preventDefault();
      window.location = url_controlador_logout;
   });

   // Configuración global modals.
	$(function() {
		var modal = $('.modal');
		$(modal).modal({
			show: false,
			backdrop: 'static'
		});
	});

	// Control de validaciones.
	$(function() {
		$('[data-toggle="requerido"]').click(function() {
			$(this).removeClass('requerido');
			$(this).next('.error').html('');
		});
	});

	// Estructura de la clase Logo.
	var Logo = function()
	{
		var _this = this;

		this.modificarNombre = function(nuevo_nombre)
		{
			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: 'modificar_nombre_logo',
					nombre: nuevo_nombre
				},
				beforeSend: function() {
					bloquear();
				},
				success: function(data) {
					if (data.datos)
						$('.navbar-brand').text(nuevo_nombre);
					desbloquear();
					cerrar_modal();
				}
			});
		}

		this.validar = function()
		{
			var aux = true;

			if ($('#nombre_logo').val() == null || $('#nombre_logo').val().length == 0
				|| /^\s+$/.test($('#nombre_logo').val()))
			{
				aux = false;
				$('#nombre_logo').addClass('requerido');
				$('#nombre_logo').next('.error').html('El campo no puede quedar vacío.');
			}

			return aux;
		}
	} // fin clase Logo.

	// Abrir modal logo.
	$('[data-toggle="modificar_logo"]').on('click', function(event) {
		event.preventDefault();
		var modal = $('#modal_logo');
		var nombre_logo_actual = $('.navbar-brand').text();
		modal.find('#nombre_logo').val(nombre_logo_actual);
		modal.modal('show');
	});

	// Actualizar logo.
	$('#form-logo').submit(function(event) {
		event.preventDefault();
		var obj_logo = new Logo();
		if (obj_logo.validar())
			obj_logo.modificarNombre($('#nombre_logo').val());
	});

	// Estructura de la clase Marquesina.
	var Marquesina = function()
	{
		var _this = this;

		this.consultaTexto = function(modal)
		{
			$.post(url_controladores, { accion: 'consulta_texto_marquesina'}, function (data) {
				modal.find('textarea[name="texto_marquee"]').val(data.datos);
		   }, 'json');
		}

		this.modificarTexto = function(nuevo_texto)
		{
			$.ajax({
				cache: false,
				dataType: 'JSON',
				type: 'POST',
				url: url_controladores,
				data: {
					accion: 'modificar_texto_marquesina',
					texto: nuevo_texto
				},
				beforeSend: function() {
					bloquear();
				},
				success: function() {
					desbloquear();
					cerrar_modal();
				}
			});
		}

	} // fin clase Marquesina.

	// Abrir modal marquesina.
	$('[data-toggle="modificar_marquee"]').on('click', function(event) {
		event.preventDefault();
		var modal = $('#modal_marquesina');
		var obj_marquesina = new Marquesina();
		modal.find('.modal-content').load('/cl/formularios/form_marquesina.html', function() {
			obj_marquesina.consultaTexto(modal);
			modal.find('#form-marquesina').submit(function (event) {
				event.preventDefault();
				obj_marquesina.modificarTexto(modal.find('textarea[name="texto_marquee"]').val());
			});
		});
		modal.modal('show');
	});

});