$(document).ready(function() {

	function actualizarPagina() {
		$.ajax({
			cache: false,
			dataType: 'JSON',
			type: 'POST',
			url: url_controladores,
			data: { accion: 'actualizar_pagina_set_interval' },
			success: function(data) {
				if (data.datos != 0) {
					window.location = url_controlador_logout;
				}
			}
		});
	} setInterval(actualizarPagina, 210000);

	function validar_preguntas() {
		var datos_correctos = true;
		$("[data-toggle='requerido']").each(function() {
			if ($("#pregunta1").val() == "") {
				datos_correctos = false;
				$("#pregunta1").addClass("requerido");
				$("#pregunta1").next(".error").html("Seleccione una pregunta");
			}
			if ($("#respuesta1").val() == null || $("#respuesta1").val().length == 0 || /^\s+$/.test($("#respuesta1").val())) {
				datos_correctos = false;
				$("#respuesta1").addClass("requerido");
				$("#respuesta1").next(".error").html("Debe escribir su respuesta");
			}
			if ($("#respuesta1_conf").val() == null || $("#respuesta1_conf").val().length == 0 || /^\s+$/.test($("#respuesta1_conf").val())) {
				datos_correctos = false;
				$("#respuesta1_conf").addClass("requerido");
				$("#respuesta1_conf").next(".error").html("Debe escribir nuevamente su respuesta");
			}
			if ($("#respuesta1").val() != $("#respuesta1_conf").val()) {
				datos_correctos = false;
				$("#respuesta1_conf").addClass("requerido");
				$("#respuesta1_conf").next(".error").html("Las respuestas no coinciden");
			}
		});
		return datos_correctos;
	}

	function validar_respuestas() {
		var datos_correctos = true;
		$("[data-toggle='requerido']").each(function() {
			if ($("#respuesta1").val() == null || $("#respuesta1").val().length == 0 || /^\s+$/.test($("#respuesta1").val())) {
				datos_correctos = false;
				$("#respuesta1").addClass("requerido");
				$("#respuesta1").next(".error").html("Debe escribir su respuesta");
			}
		});
		return datos_correctos;
	}

	function reiniciar_form() {
		$("input[type=password]").val("");
		$("select").prop('selectedIndex', 0);
		$("[data-toggle='requerido']").removeClass("requerido");
		$("#form_comprobar input[type=radio]").attr("checked", false);
		$(".error").html("");
	}

	$("#confirmar_respuestas #cancelar_btn").on("click", function (e){e.preventDefault();
		$("#confirmar_respuestas").modal("hide");
	});

	function enviar_form_preguntas()
	{
		var accion = 'registrar_pregunta_seguridad';
		var pregunta = $('#pregunta1').val();
		var respuesta = $('#respuesta1').val();
		var respuesta_confirmacion = $('#respuesta1_conf').val();

		$.ajax({
			cache: false,
			dataType: 'JSON',
			type: 'POST',
			url: url_controladores,
			data: {
				accion: accion,
				pregunta: pregunta,
				respuesta: respuesta,
				respuesta_confirmacion: respuesta_confirmacion
			},
			beforeSend:function() {
				$('#formPreguntas button, #confirmar_respuestas button').attr('disabled', 'disabled');
			},
			success:function(data) {
				if (data.datos == 2)
				{
					$('#respuesta1_conf').addClass('requerido');
					$('#respuesta1_conf').next('.error').html('Las respuestas no coinciden.');
				}
				else
					window.location = data.datos.window_location;

				$('#confirmar_respuestas').modal('hide');
				$('#formPreguntas button, #confirmar_respuestas button').removeAttr('disabled');
			}
		});
	} // fin function enviar_form_preguntas

	function enviar_form_respuestas()
	{
		var accion = 'comprobar_respuesta_seguridad';
		var respuesta = $('#respuesta1').val();

		$.ajax({
			cache: false,
			dataType: 'JSON',
			type: 'POST',
			url: url_controladores,
			data: {
				accion: accion,
				respuesta: respuesta
			},
			beforeSend:function() {
				$('#formRespuestas button').attr('disabled', 'disabled');
			},
			success:function(data) {
				if (data.datos.aux == 0)
				{
					$('#respuesta1').addClass('requerido');
					$('#respuesta1').next('.error').html('Su respuesta es incorrecta. Por favor, inténtelo nuevamente.');
				}
				else
					window.location = data.datos.window_location;

				$('#formRespuestas button').removeAttr('disabled');
			}
		});
	} // fin function enviar_form_preguntas

	$("#confirmar_respuestas #continuar_btn").on("click", function (){
		enviar_form_preguntas();
	});

	$(function(){
		$("#limpiar").click(function() {
			reiniciar_form();
		});
		$("#formPreguntas").submit(function(event) {
			if (validar_preguntas()) {
				$("#confirmar_respuestas").modal("show");
			}
			event.preventDefault();
		});
		$("#formRespuestas").submit(function(event) {
			if (validar_respuestas()) {
				enviar_form_respuestas();
			}
			event.preventDefault();
		});
	});

});