<?php

define('PAGINA', 'responder');

include '../sv/config.php';
include '../sv/clases/Notificacion.php';
include '../sv/clases/Logo.php';
include '../sv/clases/Usuario.php';
include '../sv/clases/PreguntaSeguridad.php';

session_start();

$obj_notificacion = new Notificacion();
$obj_logo = new Logo();
$obj_usuario = new Usuario();
$obj_pregunta = new PreguntaSeguridad();

if (!(isset($_SESSION['usuario'])) || !($_SESSION['tipo_usuario'])
   || $obj_usuario->verificarStatus($_SESSION['id_usuario'], $_SESSION['tipo_usuario']) == 1)
{
   header('Location: ../sv/controladores/logout.php');
}
else
{
	if ($obj_usuario->consultarValorIp($_SESSION['id_usuario']) == $_SESSION['ip'])
   {
      if ($_SESSION['tipo_usuario'] == 5)
         header('Location: ../mix/index.php');
      else
         header('Location: /');
   }
   else
   {
      switch ($obj_usuario->inicio($_SESSION['id_usuario']))
      {
         case 0: # Usuario nuevo
         case 2: # Preguntas de seguridad restablecidas
            header("Location: preguntas.php");
            break;
      }
   }
}

$obj_usuario->actualizarOnline(time(), $_SESSION['id_usuario']);

$obj_notificacion->resetSessionCantidadCargada();

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "https://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="https://www.w3.org/1999/xhtml">
<head><meta https-equiv="Content-Type" content="text/html; charset=gb18030">

<link href="/recursos/logo-shorcut.png" rel="shortcut icon" type="image/x-icon" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php printf($obj_logo->getNombreBd()) ?> - verificar preguntas de seguridad</title>
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/bootstrap/css/'.BOOTSTRAP_CSS ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/'.MAIN_CSS ?>" />
<style type="text/css"> body { padding-top:72px } h4 { margin:0 } h5 { margin-top:0 }
</style>
</head>

<body>

   <?php require '../sv/headers/menu_principal_preguntas.php' ?>

   <div class="container-fluid">
      <div class="row">
         <div id="contenido">
            <div class="col-xs-12 col-sm-8 col-sm-offset-2 col-md-8 col-md-offset-2 col-lg-6 col-lg-offset-3">
               <h5 class="text-warning">
                  <strong>ADVERTENCIA</strong>: Hemos detectado que su conexión presenta características diferentes a la habitual.
               </h5>
               <form id="formRespuestas">
                  <div class="formulario">
                     <div class="formulario-cbz">
                        <h4>Para ingresar al sistema y por motivos se seguridad, por favor responda la siguiente pregunta:</h4>
                     </div>
                     <div class="formulario-cuerpo">
                        <span class="error"></span>
                        <div class="form-group">
                           <p><?php echo $obj_pregunta->getStringPregunta($_SESSION['id_usuario']) ?></p>
                           <input type="text" id="respuesta1" name="respuesta1" data-toggle="requerido">
                           <span class="error"></span>
                        </div>
                     </div> <!-- /.formulario-cuerpo -->
                     <div class="formulario-pie">
                        <button type="reset" class="btn btn-info" id="limpiar">Limpiar</button>
                        <button type="submit" class="btn btn-info" id="enviar_preguntas">Continuar</button>
                     </div> <!-- /.formulario-pie -->
                  </div> <!-- /.formulario -->
               </form>
            </div> <!-- /.col-* -->
         </div> <!-- /#contenido -->
      </div> <!-- /.row -->
   </div> <!-- /.container -->

  <script type="application/javascript" src="/librerias/jquery/jquery/jquery-1.10.2.js"></script>
  <script type="application/javascript" src="/librerias/bootstrap/js/bootstrap.min.js"></script>
  <script type="application/javascript" src="<?php echo '/js/'.GLOBAL_JS ?>"></script>
  <script type="application/javascript" src="<?php echo '/js/'.PREGUNTAS_JS ?>"></script>

</body>
</html>