<?php

define('PAGINA', 'reportes');

include '../sv/config.php';
include '../sv/clases/Usuario.php';
include '../sv/clases/Notificacion.php';
include '../sv/clases/Suscripcion.php';
include '../sv/clases/Logo.php';
include '../sv/clases/Reporte.php';

session_start();

$obj_notificacion = new Notificacion();
$obj_suscripcion = new Suscripcion();
$obj_logo = new Logo();
$obj_reporte = new Reporte();
$obj_usuario = new Usuario();

if (!(isset($_SESSION['usuario'])) || ($_SESSION['tipo_usuario'] != 1)
   || $obj_usuario->verificarStatus($_SESSION['id_usuario'], $_SESSION['tipo_usuario']) == 1)
{
   header('Location: ../sv/controladores/logout.php');
}
else
{
   if ($obj_usuario->consultarValorIp($_SESSION['id_usuario']) != $_SESSION['ip'])
      header('Location: responder.php');
   else
   {
      switch ($obj_usuario->inicio($_SESSION['id_usuario']))
      {
         case 0: # Usuario nuevo
         case 2: # Preguntas de seguridad restablecidas
            header("Location: preguntas.php");
            break;
      }
   }
}

$obj_usuario->actualizarOnline(time(), $_SESSION['id_usuario']);
$obj_suscripcion->entradaSuscripcion();

$f1_get = (isset($_GET['f1'])) ? $_GET['f1'] : 0;
$sem_get = (isset($_GET['sem']) && ($_GET['sem'] >= 1 && $_GET['sem'] <= 53)) ? $_GET['sem'] : 0;
$pag_num_get = (isset($_GET['pag']) && $_GET['pag'] >=1) ? $_GET['pag'] : 1;

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "https://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="https://www.w3.org/1999/xhtml">
<head>
<meta https-equiv="Content-Type" content="text/html; charset=utf-8" />
<link href="/recursos/logo-shorcut.png" rel="shortcut icon" type="image/x-icon" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php printf($obj_logo->getNombreBd()) ?> - reportes</title>
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/bootstrap/css/'.BOOTSTRAP_CSS ?>" />
<link type="text/css" rel="stylesheet"
   href="<?php echo '/librerias/bootstrap-datepicker-1.6.1/css/'.DATEPICKER_CSS ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/'.MAIN_CSS ?>" />
<style type="text/css"> body { padding-top: 107px } </style>
</head>

<body id="reportes">
   
   <input id="f1" type="hidden" value="<?php echo $f1_get ?>" />
   <input id="sem" type="hidden" value="<?php echo $sem_get ?>" />
   <input id="pag_num" type="hidden" value="<?php echo $pag_num_get ?>" />

   <?php require '../sv/headers/menu_principal_admin.php' ?>

   <div class="container-fluid">
      <div class="row">
         <div id="contenido">
            <?php echo $obj_reporte->__html($f1_get, $sem_get, $pag_num_get) ?>
         </div> <!-- /#contenido -->
      </div> <!-- /.row -->
   </div> <!-- /.container -->

   <div class="modal bs-example-modal-sm" id="modal_logo" tabindex="-1" role="dialog"
      aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-sm">
         <div class="modal-content">
            <form id="form-logo">
               <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">
                     <span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
                  </button>
                  <h4 class="modal-title" id="myModalLabel">Modificar logo</h4>
               </div>
               <div class="modal-body" >
                  <div class="form-group">
                     <p>Nombre</p>
                     <input type="text" id="nombre_logo" data-toggle="requerido" /><span class="error"></span>
                  </div>
               </div>
               <div class="modal-footer">
                  <button type="button" class="btn btn-info" data-dismiss="modal">Cancelar</button>
                  <button type="submit" id="continuar_btn_logo" class="btn btn-info">Guardar cambios</button>
               </div>
            </form>
         </div> <!-- /.modal-content -->
      </div> <!-- /.modal-dialog -->
   </div> <!-- /#modal-logo -->

   <div class="modal bs-example-modal-lg" id="modal_canales" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog modal-lg">
         <div class="modal-content">
            <!-- -->
         </div> <!-- /.modal-content -->
      </div> <!-- /.modal-dialog -->
   </div> <!-- /.modal -->

   <div class="modal bs-example-modal-md" id="modal_marquesina" tabindex="-1" role="dialog"
      aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-md">
         <div class="modal-content">
            <!-- -->
         </div> <!-- /.modal-content -->
      </div> <!-- /.modal-dialog -->
   </div> <!-- /#modal-marquesina -->

   <script type="application/javascript" src="/librerias/jquery/jquery/jquery-1.10.2.js"></script>
   <script type="application/javascript" src="/librerias/bootstrap/js/bootstrap.min.js"></script>
   <script type="application/javascript" src="<?php echo '/js/'.GLOBAL_JS ?>"></script>
   <script type="application/javascript" src="<?php echo '/js/'.REPORTES_JS ?>"></script>
   <script type="application/javascript" src="<?php echo '/js/'.CANALES_JS ?>"></script>
   <script type="application/javascript"
      src="<?php echo '/librerias/bootstrap-datepicker-1.6.1/js/'.DATEPICKER_JS ?>"></script>
   <script type="application/javascript"
      src="<?php echo '/librerias/bootstrap-datepicker-1.6.1/locales/'.DATEPICKER_ES_JS ?>"></script>

</body>
</html>