<?php

define('PAGINA', 'notificaciones');

include '../sv/config.php';
include '../sv/clases/Notificacion.php';
include '../sv/clases/Suscripcion.php';
include '../sv/clases/Logo.php';
include '../sv/clases/Usuario.php';

session_start();

$obj_notificacion = new Notificacion();
$obj_suscripcion = new Suscripcion();
$obj_logo = new Logo();
$obj_usuario = new Usuario();

if (!(isset($_SESSION['usuario'])) || ($_SESSION['tipo_usuario'] > 2)
   || $obj_usuario->verificarStatus($_SESSION['id_usuario'], $_SESSION['tipo_usuario']) == 1)
{
   header('Location: ../sv/controladores/logout.php');
}
else
{
   /*if ( consultar_ip($_SESSION['id_usuario']) != $_SESSION['ip'] ) # Para versión sin preguntas de seguridad
      header("Location: ../sv/logout.php");*/

   if ($obj_usuario->consultarValorIp($_SESSION['id_usuario']) != $_SESSION['ip'])
      header("Location: responder.php");
   else
   {
      switch ($obj_usuario->inicio($_SESSION['id_usuario']))
      {
         case 0: # Usuario nuevo
         case 2: # Preguntas de seguridad restablecidas
            header("Location: preguntas.php");
            break;
      }
   }
}

$obj_usuario->actualizarOnline(time(), $_SESSION['id_usuario']);
$obj_suscripcion->entradaSuscripcion();

$obj_notificacion->resetSessionCantidadCargada();

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "https://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="https://www.w3.org/1999/xhtml">
<head>
<meta https-equiv="Content-Type" content="text/html; charset=utf-8" />
<link href="../recursos/logo-shorcut.png" rel="shortcut icon" type="image/x-icon" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php printf($obj_logo->getNombreBd()) ?> - usuarios activos</title>
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/bootstrap/css/'.BOOTSTRAP_CSS ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo '/librerias/'.MAIN_CSS ?>" />
<link type="text/css" rel="stylesheet" href="/librerias/jquery/css/jquery-ui-1.10.4.custom.min.css" />
<style type="text/css"> body { padding-top: 107px } </style>
</head>

<body>
   <?php require '../sv/headers/menu_principal_admin.php' ?>

   <div class="container-fluid">
      <div class="row">
         <div id="contenido">
            <?php echo $obj_notificacion->__vistaHtml() ?>
         </div> <!-- /#contenido -->
      </div> <!-- /.row -->
   </div> <!-- /.container -->

   <div class="modal bs-example-modal-lg" id="modal_canales" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
         <div class="modal-dialog modal-lg">
            <div class="modal-content">
               <!-- -->
            </div> <!-- /.modal-content -->
         </div> <!-- /.modal-dialog -->
   </div> <!-- /.modal -->

   <?php if ($_SESSION['tipo_usuario'] == 1) { ?>

      <div class="modal bs-example-modal-sm" id="modal_logo" tabindex="-1" role="dialog"
         aria-labelledby="myModalLabel" aria-hidden="true">
         <div class="modal-dialog modal-sm">
            <div class="modal-content">
               <form id="form-logo">
                  <div class="modal-header">
                     <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
                     </button>
                     <h4 class="modal-title" id="myModalLabel">Modificar logo</h4>
                  </div>
                  <div class="modal-body" >
                     <div class="form-group">
                        <p>Nombre</p>
                        <input type="text" id="nombre_logo" data-toggle="requerido" /><span class="error"></span>
                     </div>
                  </div>
                  <div class="modal-footer">
                     <button type="button" class="btn btn-info" data-dismiss="modal">Cancelar</button>
                     <button type="submit" id="continuar_btn_logo" class="btn btn-info">Guardar cambios</button>
                  </div>
               </form>
            </div> <!-- /.modal-content -->
         </div> <!-- /.modal-dialog -->
      </div> <!-- /#modal-logo -->

      <div class="modal" id="modal_confirmar" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
         <div class="modal-dialog">
            <div class="modal-content">
               <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">
                     <span aria-hidden="true">&times;</span><span class="sr-only">Close</span>
                  </button>
                  <h4 class="modal-title" id="myModalLabel">Eliminar notificaciones</h4>
               </div>
               <div class="modal-body" >
                  <p><!-- --></p>
               </div>
               <div class="modal-footer">
                  <button type="button" class="btn btn-info" data-dismiss="modal">Cancelar</button>
                  <button type="button" id="continuar_btn" class="btn btn-info">Continuar</button>
               </div>
            </div>
         </div>
      </div>

      <div class="modal bs-example-modal-md" id="modal_marquesina" tabindex="-1" role="dialog"
         aria-labelledby="myModalLabel" aria-hidden="true">
         <div class="modal-dialog modal-md">
            <div class="modal-content">
               <!-- -->
            </div> <!-- /.modal-content -->
         </div> <!-- /.modal-dialog -->
      </div> <!-- /#modal-marquesina -->

   <?php } ?>

   <script type="application/javascript" src="/librerias/jquery/jquery/jquery-1.10.2.js"></script>
   <script type="application/javascript" src="/librerias/bootstrap/js/bootstrap.min.js"></script>
   <script type="application/javascript" src="/librerias/jquery/js/jquery-ui-1.10.4.custom.min.js"></script>
   <script type="application/javascript" src="<?php echo '/js/'.GLOBAL_JS ?>"></script>
   <script type="application/javascript" src="<?php echo '/js/'.ADMIN_NOTIFICACIONES_JS ?>"></script>
   <script type="application/javascript" src="<?php echo '/js/'.CANALES_JS ?>"></script>

</body>
</html>